/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.transcode;

import com.ximpleware.TranscodeException;
import com.ximpleware.transcode.ASCII_Coder;
import com.ximpleware.transcode.ISO8859_1Coder;
import com.ximpleware.transcode.UTF16BE_Coder;
import com.ximpleware.transcode.UTF16LE_Coder;
import com.ximpleware.transcode.UTF8_Coder;
import java.io.IOException;
import java.io.OutputStream;

public class Transcoder {
    public static byte[] transcode(byte[] byArray, int n, int n2, int n3, int n4) throws TranscodeException {
        int n5 = Transcoder.getOutLength(byArray, n, n2, n3, n4);
        byte[] byArray2 = new byte[n5];
        Transcoder.transcodeAndFill(byArray, byArray2, n, n2, n3, n4);
        return byArray2;
    }

    public static final int getOutLength(byte[] byArray, int n, int n2, int n3, int n4) throws TranscodeException {
        int n5 = 0;
        int n6 = n;
        while (n6 < n + n2) {
            long l = Transcoder.decode(byArray, n6, n3);
            n6 = (int)(l >> 32);
            int n7 = (int)l;
            n5 += Transcoder.getLen(n7, n4);
        }
        return n5;
    }

    public static final void transcodeAndFill(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) throws TranscodeException {
        boolean bl = false;
        int n5 = n;
        int n6 = 0;
        while (n5 < n + n2) {
            long l = Transcoder.decode(byArray, n5, n3);
            n5 = (int)(l >> 32);
            int n7 = (int)l;
            n6 = Transcoder.encode(byArray2, n6, n7, n4);
        }
    }

    public static final int transcodeAndFill2(int n, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, int n5) throws TranscodeException {
        boolean bl = false;
        int n6 = n2;
        int n7 = n;
        while (n6 < n2 + n3) {
            long l = Transcoder.decode(byArray, n6, n4);
            n6 = (int)(l >> 32);
            int n8 = (int)l;
            n7 = Transcoder.encode(byArray2, n7, n8, n5);
        }
        return n7;
    }

    public static final void transcodeAndWrite(byte[] byArray, OutputStream outputStream, int n, int n2, int n3, int n4) throws TranscodeException, IOException {
        boolean bl = false;
        int n5 = n;
        while (n5 < n + n2) {
            long l = Transcoder.decode(byArray, n5, n3);
            n5 = (int)(l >> 32);
            int n6 = (int)l;
            Transcoder.encodeAndWrite(outputStream, n6, n4);
        }
    }

    public static final int getLen(int n, int n2) throws TranscodeException {
        switch (n2) {
            case 0: {
                return ASCII_Coder.getLen(n);
            }
            case 2: {
                return UTF8_Coder.getLen(n);
            }
            case 1: {
                return ISO8859_1Coder.getLen(n);
            }
            case 64: {
                return UTF16LE_Coder.getLen(n);
            }
            case 63: {
                return UTF16BE_Coder.getLen(n);
            }
        }
        throw new TranscodeException("Unsupported encoding");
    }

    public static final long decode(byte[] byArray, int n, int n2) throws TranscodeException {
        switch (n2) {
            case 0: {
                return ASCII_Coder.decode(byArray, n);
            }
            case 2: {
                return UTF8_Coder.decode(byArray, n);
            }
            case 1: {
                return ISO8859_1Coder.decode(byArray, n);
            }
            case 64: {
                return UTF16LE_Coder.decode(byArray, n);
            }
            case 63: {
                return UTF16BE_Coder.decode(byArray, n);
            }
        }
        throw new TranscodeException("Unsupported encoding");
    }

    public static final int encode(byte[] byArray, int n, int n2, int n3) throws TranscodeException {
        switch (n3) {
            case 0: {
                return ASCII_Coder.encode(byArray, n, n2);
            }
            case 2: {
                return UTF8_Coder.encode(byArray, n, n2);
            }
            case 1: {
                return ISO8859_1Coder.encode(byArray, n, n2);
            }
            case 64: {
                return UTF16LE_Coder.encode(byArray, n, n2);
            }
            case 63: {
                return UTF16BE_Coder.encode(byArray, n, n2);
            }
        }
        throw new TranscodeException("Unsupported encoding");
    }

    public static final void encodeAndWrite(OutputStream outputStream, int n, int n2) throws TranscodeException, IOException {
        switch (n2) {
            case 0: {
                ASCII_Coder.encodeAndWrite(outputStream, n);
                return;
            }
            case 2: {
                UTF8_Coder.encodeAndWrite(outputStream, n);
                return;
            }
            case 1: {
                ISO8859_1Coder.encodeAndWrite(outputStream, n);
                return;
            }
            case 64: {
                UTF16LE_Coder.encodeAndWrite(outputStream, n);
                return;
            }
            case 63: {
                UTF16BE_Coder.encodeAndWrite(outputStream, n);
                return;
            }
        }
        throw new TranscodeException("Unsupported encoding");
    }
}

