/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.FastIntBuffer;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.IndexReadException;
import com.ximpleware.IndexWriteException;
import com.ximpleware.VTDGen;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class IndexHandler {
    public static final int OFFSET_ADJUSTMENT = 32;

    IndexHandler() {
    }

    public static void writeIndex(byte by, int n, boolean bl, boolean bl2, int n2, int n3, int n4, byte[] byArray, int n5, int n6, FastLongBuffer fastLongBuffer, FastLongBuffer fastLongBuffer2, FastLongBuffer fastLongBuffer3, FastIntBuffer fastIntBuffer, OutputStream outputStream) throws IndexWriteException, IOException {
        int n7;
        if (byArray == null || n6 <= 0 || fastLongBuffer == null || fastLongBuffer2 == null || fastLongBuffer3 == null || fastIntBuffer == null) {
            throw new IndexWriteException("Invalid VTD index ");
        }
        if (fastLongBuffer.size() == 0) {
            throw new IndexWriteException("VTDBuffer can't be zero length");
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        byte[] byArray2 = new byte[]{by, (byte)n, (byte)(bl ? 224 : 160), (byte)n2};
        dataOutputStream.write(byArray2);
        byArray2[0] = 0;
        byArray2[1] = 4;
        byArray2[2] = (byte)((n4 & 0xFF00) >> 8);
        byArray2[3] = (byte)(n4 & 0xFF);
        dataOutputStream.write(byArray2);
        byArray2[3] = 0;
        byArray2[2] = 0;
        byArray2[1] = 0;
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.write(byArray2);
        dataOutputStream.writeLong(n6);
        dataOutputStream.write(byArray, n5, n6);
        if ((n6 & 7) != 0) {
            for (int i = ((n6 >> 3) + 1 << 3) - n6; i > 0; --i) {
                dataOutputStream.write(0);
            }
        }
        dataOutputStream.writeLong(fastLongBuffer.size());
        if (n5 == 0) {
            for (n7 = 0; n7 < fastLongBuffer.size(); ++n7) {
                dataOutputStream.writeLong(fastLongBuffer.longAt(n7));
            }
        } else {
            for (n7 = 0; n7 < fastLongBuffer.size(); ++n7) {
                dataOutputStream.writeLong(IndexHandler.adjust(fastLongBuffer.longAt(n7), -n5));
            }
        }
        dataOutputStream.writeLong(fastLongBuffer2.size());
        for (n7 = 0; n7 < fastLongBuffer2.size(); ++n7) {
            dataOutputStream.writeLong(fastLongBuffer2.longAt(n7));
        }
        dataOutputStream.writeLong(fastLongBuffer3.size());
        for (n7 = 0; n7 < fastLongBuffer3.size(); ++n7) {
            dataOutputStream.writeLong(fastLongBuffer3.longAt(n7));
        }
        dataOutputStream.writeLong(fastIntBuffer.size());
        for (n7 = 0; n7 < fastIntBuffer.size(); ++n7) {
            dataOutputStream.writeInt(fastIntBuffer.intAt(n7));
        }
        if ((fastIntBuffer.size() & 1) != 0) {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.close();
    }

    public static void readIndex(byte[] byArray, VTDGen vTDGen) throws IndexReadException {
        if (byArray == null || vTDGen == null) {
            throw new IllegalArgumentException("Invalid argument(s) for readIndex()");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte by = byteBuffer.get();
        vTDGen.encoding = byteBuffer.get();
        int n = 32;
        if (vTDGen.encoding >= 63) {
            n = 16;
        }
        boolean bl = ((by = byteBuffer.get()) & 0x80) != 0;
        vTDGen.ns = (by & 0x40) != 0;
        boolean bl2 = (by & 0x20) != 0;
        if ((by & 0x1F) != 0) {
            throw new IndexReadException("Last 5 bits of the third byte should be zero");
        }
        vTDGen.VTDDepth = byteBuffer.get();
        int n2 = byteBuffer.get() << 8 | byteBuffer.get();
        if (n2 < 3) {
            throw new IndexReadException("LC levels must be at least 3");
        }
        vTDGen.rootIndex = byteBuffer.get() << 8 | byteBuffer.get();
        byteBuffer.getLong();
        byteBuffer.getLong();
        int n3 = 0;
        n3 = bl2 ? (int)byteBuffer.getLong() : (int)IndexHandler.reverseLong(byteBuffer.getLong());
        int n4 = 0;
        if ((n3 & 7) != 0) {
            n4 = ((n3 >> 3) + 1 << 3) - n3;
        }
        vTDGen.setDoc_BR(byArray, 0, n3 + 32);
        byteBuffer = ByteBuffer.wrap(byArray, 32 + n3 + n4, byArray.length - 32 - n3 - n4);
        if (bl2) {
            int n5;
            for (int i = (int)byteBuffer.getLong(); i > 0; --i) {
                vTDGen.VTDBuffer.append(IndexHandler.adjust(byteBuffer.getLong(), n));
            }
            for (int i = (int)byteBuffer.getLong(); i > 0; --i) {
                long l = byteBuffer.getLong();
                vTDGen.l1Buffer.append(l);
            }
            for (int i = (int)byteBuffer.getLong(); i > 0; --i) {
                vTDGen.l2Buffer.append(byteBuffer.getLong());
            }
            if (bl) {
                for (n5 = (int)byteBuffer.getLong(); n5 > 0; --n5) {
                    vTDGen.l3Buffer.append(byteBuffer.getInt());
                }
            } else {
                while (n5 > 0) {
                    vTDGen.l3Buffer.append((int)(byteBuffer.getLong() >> 32));
                    --n5;
                }
            }
        } else {
            int n6;
            for (int i = (int)IndexHandler.reverseLong(byteBuffer.getLong()); i > 0; --i) {
                vTDGen.VTDBuffer.append(IndexHandler.adjust(IndexHandler.reverseLong(byteBuffer.getLong()), n));
            }
            for (int i = (int)IndexHandler.reverseLong(byteBuffer.getLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(byteBuffer.getLong());
                vTDGen.l1Buffer.append(l);
            }
            for (int i = (int)IndexHandler.reverseLong(byteBuffer.getLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(byteBuffer.getLong());
                vTDGen.l2Buffer.append(l);
            }
            if (bl) {
                for (n6 = (int)IndexHandler.reverseLong(byteBuffer.getLong()); n6 > 0; --n6) {
                    vTDGen.l3Buffer.append(IndexHandler.reverseInt(byteBuffer.getInt()));
                }
            } else {
                while (n6 > 0) {
                    vTDGen.l3Buffer.append(IndexHandler.reverseInt((int)(byteBuffer.getLong() >> 32)));
                    --n6;
                }
            }
        }
    }

    public static void readIndex(InputStream inputStream, VTDGen vTDGen) throws IndexReadException, IOException {
        int n;
        if (inputStream == null || vTDGen == null) {
            throw new IndexReadException("Invalid argument(s) for readIndex()");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by = dataInputStream.readByte();
        vTDGen.encoding = dataInputStream.readByte();
        by = dataInputStream.readByte();
        boolean bl = (by & 0x80) != 0;
        vTDGen.ns = (by & 0x40) != 0;
        boolean bl2 = (by & 0x20) != 0;
        if ((by & 0x1F) != 0) {
            throw new IndexReadException("Last 5 bits of the third byte should be zero");
        }
        vTDGen.VTDDepth = dataInputStream.readByte();
        int n2 = dataInputStream.readByte() << 8 | dataInputStream.readByte();
        if (n2 < 3) {
            throw new IndexReadException("LC levels must be at least 3");
        }
        vTDGen.rootIndex = dataInputStream.readByte() << 8 | dataInputStream.readByte();
        dataInputStream.readLong();
        dataInputStream.readLong();
        int n3 = 0;
        n3 = bl2 ? (int)dataInputStream.readLong() : (int)IndexHandler.reverseLong(dataInputStream.readLong());
        byte[] byArray = new byte[n3];
        dataInputStream.read(byArray);
        if ((n3 & 7) != 0) {
            for (n = ((n3 >> 3) + 1 << 3) - n3; n > 0; --n) {
                dataInputStream.readByte();
            }
        }
        vTDGen.setDoc(byArray);
        if (bl2) {
            int n4;
            for (n = (int)dataInputStream.readLong(); n > 0; --n) {
                vTDGen.VTDBuffer.append(dataInputStream.readLong());
            }
            for (int i = (int)dataInputStream.readLong(); i > 0; --i) {
                long l = dataInputStream.readLong();
                vTDGen.l1Buffer.append(l);
            }
            for (int i = (int)dataInputStream.readLong(); i > 0; --i) {
                vTDGen.l2Buffer.append(dataInputStream.readLong());
            }
            if (bl) {
                for (n4 = (int)dataInputStream.readLong(); n4 > 0; --n4) {
                    vTDGen.l3Buffer.append(dataInputStream.readInt());
                }
            } else {
                while (n4 > 0) {
                    vTDGen.l3Buffer.append((int)(dataInputStream.readLong() >> 32));
                    --n4;
                }
            }
        } else {
            int n5;
            for (n = (int)IndexHandler.reverseLong(dataInputStream.readLong()); n > 0; --n) {
                vTDGen.VTDBuffer.append(IndexHandler.reverseLong(dataInputStream.readLong()));
            }
            for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(dataInputStream.readLong());
                vTDGen.l1Buffer.append(l);
            }
            for (int i = (int)IndexHandler.reverseLong(dataInputStream.readLong()); i > 0; --i) {
                long l = IndexHandler.reverseLong(dataInputStream.readLong());
                vTDGen.l2Buffer.append(l);
            }
            if (bl) {
                for (n5 = (int)IndexHandler.reverseLong(dataInputStream.readLong()); n5 > 0; --n5) {
                    vTDGen.l3Buffer.append(IndexHandler.reverseInt(dataInputStream.readInt()));
                }
            } else {
                while (n5 > 0) {
                    vTDGen.l3Buffer.append(IndexHandler.reverseInt((int)(dataInputStream.readLong() >> 32)));
                    --n5;
                }
            }
        }
    }

    private static long reverseLong(long l) {
        long l2 = (l & 0xFF00000000000000L) >>> 56 | (l & 0xFF000000000000L) >> 40 | (l & 0xFF0000000000L) >> 24 | (l & 0xFF00000000L) >> 8 | (l & 0xFF000000L) << 8 | (l & 0xFF0000L) << 24 | (l & 0xFF00L) << 40 | (l & 0xFFL) << 56;
        return l2;
    }

    private static int reverseInt(int n) {
        int n2 = (n & 0xFF000000) >>> 24 | (n & 0xFF0000) >> 8 | (n & 0xFF00) << 8 | (n & 0xFF) << 24;
        return n2;
    }

    private static long adjust(long l, int n) {
        long l2 = (l & 0xFFFFFFFFL) + (long)n;
        long l3 = l & 0xFFFFFFFF00000000L;
        return l2 | l3;
    }
}

