/*
 * Decompiled with CFR 0.152.
 */
package cl.utfsm.acs.xml;

import cl.utfsm.acs.types.AcsAttribute;
import cl.utfsm.acs.types.AcsComplexType;
import cl.utfsm.acs.types.AcsSimpleType;
import cl.utfsm.acs.types.AcsType;
import java.util.ArrayList;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonSchema {
    protected static String COMMON_TYPES = "commontypes.xsd";
    protected DOMParser parser = new DOMParser();
    protected Document commonTypes;
    protected ArrayList<AcsType> typeList;

    public CommonSchema() {
        String string = System.getProperty("ACS.acsroot");
        if (string != null) {
            try {
                this.parser.parse(string + "/idl/" + COMMON_TYPES);
                this.commonTypes = this.parser.getDocument();
            }
            catch (Exception exception) {
                exception.getMessage();
            }
        } else {
            throw new NullPointerException("Property 'ACS.acsroot' must be defined!");
        }
        this.searchSimpleTypes(this.commonTypes, "common");
        this.typeList.add(new AcsSimpleType("xs", "string", "A string", null));
        this.typeList.add(new AcsSimpleType("xs", "boolean", "A boolean", null));
        this.searchComplexTypes(this.commonTypes, "common");
    }

    public void searchSimpleTypes(Document document, String string) {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        String string2 = "";
        NodeList nodeList = document.getElementsByTagName("xs:simpleType");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string3 = node.getAttributes().getNamedItem("name").getNodeValue();
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                String string4 = node2.getLocalName();
                if (string4 == null || string4.compareTo("annotation") != 0) continue;
                string2 = this.readDocumentation(node2);
            }
            AcsSimpleType acsSimpleType = new AcsSimpleType(string, string3, string2, null);
            this.typeList.add(acsSimpleType);
        }
    }

    public AcsAttribute readAttribute(Node node) {
        AcsSimpleType acsSimpleType;
        String string = "";
        String string2 = node.getAttributes().getNamedItem("name").getNodeValue();
        String string3 = node.getAttributes().getNamedItem("type").getNodeValue();
        try {
            string = node.getAttributes().getNamedItem("use").getNodeValue();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        try {
            acsSimpleType = (AcsSimpleType)this.getType(string3.split(":")[1]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            acsSimpleType = (AcsSimpleType)this.getType(string3);
        }
        AcsAttribute acsAttribute = new AcsAttribute(string2, acsSimpleType, string);
        return acsAttribute;
    }

    public String readDocumentation(Node node) {
        String string = "";
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getLocalName();
            if (string2 == null || string2.compareTo("documentation") != 0) continue;
            string = node2.getFirstChild().getNodeValue();
        }
        return string;
    }

    public void searchComplexTypes(Document document, String string) {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        NodeList nodeList = document.getElementsByTagName("xs:complexType");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            String string2 = node.getAttributes().getNamedItem("name").getNodeValue();
            NodeList nodeList2 = node.getChildNodes();
            String string3 = "";
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                object = node2.getLocalName();
                if (object == null || ((String)object).compareTo("annotation") != 0) continue;
                string3 = this.readDocumentation(node2);
            }
            AcsComplexType acsComplexType = new AcsComplexType(string, string2, string3);
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                object = nodeList2.item(j);
                String string4 = object.getLocalName();
                if (string4 == null || string4.compareTo("attribute") != 0) continue;
                acsComplexType.addAttr(this.readAttribute((Node)object));
            }
            this.typeList.add(acsComplexType);
        }
    }

    public AcsType getType(String string) {
        for (AcsType acsType : this.typeList) {
            if (acsType.name.compareTo(string) != 0) continue;
            return acsType;
        }
        return null;
    }
}

