/*
 * Decompiled with CFR 0.152.
 */
package cl.utfsm.acs.ebe.util;

import cl.utfsm.acs.ebe.Error;
import cl.utfsm.acs.ebe.ErrorBrowserEditor;
import cl.utfsm.acs.ebe.Member;
import cl.utfsm.acs.types.SimpleObject;
import java.lang.reflect.Array;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class MembersTableModel
extends AbstractTableModel {
    private Object[][] tableObjects;
    private TreeMap<String, Member> members = null;
    private ErrorBrowserEditor editor;
    private static String[] columnNames = new String[]{"Name", "Type", "Description"};

    public MembersTableModel() {
    }

    public MembersTableModel(ErrorBrowserEditor errorBrowserEditor) {
        this.editor = errorBrowserEditor;
        this.members = errorBrowserEditor.getSelectedError().getMembers();
        this.tableObjects = new Object[this.members.size()][3];
        int n = 0;
        for (Member member : this.members.values()) {
            this.tableObjects[n][0] = member.getAttributes().get("name").toString();
            this.tableObjects[n][1] = member.getAttributes().get("type").toString();
            this.tableObjects[n][2] = member.getAttributes().get("description").toString();
            ++n;
        }
    }

    @Override
    public int getRowCount() {
        if (this.tableObjects != null) {
            return Array.getLength(this.tableObjects);
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tableObjects[n][n2];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        SimpleObject simpleObject;
        TreeMap<String, SimpleObject> treeMap = this.members.get(this.tableObjects[n][0].toString()).getAttributes();
        String string = this.tableObjects[n][n2].toString();
        this.tableObjects[n][n2] = object;
        if (n2 == 0) {
            Error error = this.editor.getSelectedError();
            Member member = error.getMembers().get(string);
            error.getMembers().remove(string);
            member.setValue(object.toString());
            member.setAttributeValue("name", object.toString());
            error.getMembers().put(member.getValue(), member);
            this.editor.refreshMembersTable();
            return;
        }
        if (n2 == 1) {
            simpleObject = treeMap.get("type");
            simpleObject.setValue(object.toString());
            treeMap.put("type", simpleObject);
        }
        if (n2 == 2) {
            simpleObject = treeMap.get("description");
            simpleObject.setValue(object.toString());
            treeMap.put("description", simpleObject);
        }
    }
}

