/*
 * Decompiled with CFR 0.152.
 */
package cl.utfsm.acs.ebe.util;

import cl.utfsm.acs.ebe.EbeDocument;
import cl.utfsm.acs.ebe.ErrorBrowserEditor;
import cl.utfsm.acs.types.ComplexObject;
import cl.utfsm.acs.types.SimpleObject;
import cl.utfsm.acs.types.TypedObject;
import java.lang.reflect.Array;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class EbeTableModel
extends AbstractTableModel {
    private Object[][] tableObjects;
    private TreeMap<String, SimpleObject> attrs = null;
    private ComplexObject complex;
    private ErrorBrowserEditor editor;
    private static String[] columnNames = new String[]{"Attribute Name", "Attribute Value"};

    public EbeTableModel() {
    }

    public EbeTableModel(ComplexObject complexObject, ErrorBrowserEditor errorBrowserEditor) {
        this.complex = complexObject;
        this.editor = errorBrowserEditor;
        this.attrs = complexObject.getAttributes();
        this.tableObjects = new Object[this.attrs.size()][2];
        int n = 0;
        for (String string : this.attrs.keySet()) {
            this.tableObjects[n][0] = string;
            this.tableObjects[n][1] = this.attrs.get(string).getValue();
            ++n;
        }
    }

    @Override
    public int getRowCount() {
        if (this.tableObjects != null) {
            return Array.getLength(this.tableObjects);
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tableObjects[n][n2];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 >= 1;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Object object2;
        String string = this.tableObjects[n][0].toString();
        this.tableObjects[n][n2] = object;
        if (!(this.complex instanceof EbeDocument) && string.compareTo("name") == 0) {
            object2 = this.editor.getSelectedDoc();
            ((EbeDocument)object2).getNodes().remove(this.complex.getValue());
            this.complex.setValue(object.toString());
            ((EbeDocument)object2).getNodes().put(this.complex.getValue(), this.complex);
            this.editor.refreshDocsTree();
            this.editor.publicRefreshNodeTree();
        } else if (this.complex instanceof EbeDocument && string.compareTo("name") == 0) {
            object2 = this.editor.getManager().getDocuments();
            ((TreeMap)object2).remove(this.complex.getValue());
            this.complex.setValue(object.toString());
            ((TreeMap)object2).put(this.complex.getValue(), (EbeDocument)this.complex);
        }
        object2 = this.attrs.get(string);
        ((TypedObject)object2).setValue(object.toString());
        this.attrs.put(string, (SimpleObject)object2);
    }
}

