/*
 * Decompiled with CFR 0.152.
 */
package cl.utfsm.acs.ebe;

import cl.utfsm.acs.ebe.Completion;
import cl.utfsm.acs.ebe.EbeDocument;
import cl.utfsm.acs.ebe.Error;
import cl.utfsm.acs.ebe.ErrorBrowserEditor;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class ErrorTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon errorIcon = ErrorTreeCellRenderer.createImageIcon("util/images/error.gif");
    private static final ImageIcon completionIcon = ErrorTreeCellRenderer.createImageIcon("util/images/completion.gif");
    private static final ImageIcon documentIcon = ErrorTreeCellRenderer.createImageIcon("util/images/document.gif");
    private static final long serialVersionUID = 2773311893986633892L;

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (this.isError(object)) {
            this.setIcon(errorIcon);
        } else if (this.isCompletion(object)) {
            this.setIcon(completionIcon);
        } else if (this.isDocument(object)) {
            this.setIcon(documentIcon);
        } else {
            this.setToolTipText("Here comes a Tooltip :)");
        }
        this.setToolTipText("Here comes a Tooltip :)");
        return this;
    }

    protected boolean isDocument(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        return object2 instanceof EbeDocument;
    }

    protected boolean isError(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        return object2 instanceof Error;
    }

    protected boolean isCompletion(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        return object2 instanceof Completion;
    }

    protected static ImageIcon createImageIcon(String string) {
        URL uRL = ErrorBrowserEditor.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        System.err.println("Couldn't find file:" + string);
        return null;
    }
}

