/*
 * Decompiled with CFR 0.152.
 */
package cl.utfsm.acs.ebe;

import cl.utfsm.acs.ebe.Completion;
import cl.utfsm.acs.ebe.EbeDocument;
import cl.utfsm.acs.ebe.Error;
import cl.utfsm.acs.ebe.ErrorBrowserEditor;
import cl.utfsm.acs.ebe.ErrorSchema;
import cl.utfsm.acs.ebe.Member;
import cl.utfsm.acs.types.AcsComplexType;
import cl.utfsm.acs.xml.XmlSeeker;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;

public class EbeDocumentManager {
    TreeMap<String, EbeDocument> documents;
    ErrorSchema schema;

    public EbeDocumentManager() {
        ErrorBrowserEditor.log("=== Welcome to Error Browser ===");
        ErrorBrowserEditor.log("\tDeveloped by ACS-UTFSM Group\n");
        ErrorBrowserEditor.log("[Initializating Document Manager]");
        ErrorBrowserEditor.log("   * Reading Schema file");
        this.schema = new ErrorSchema();
        ErrorBrowserEditor.log("   * Configuring Classes");
        Member.setClassType((AcsComplexType)this.schema.getType("Member_"));
        Error.setClassType(this.schema.getErrorSchema());
        Completion.setClassType(this.schema.getCompletionSchema());
        EbeDocument.setClassType(this.schema.getTypeSchema());
        ErrorBrowserEditor.log("   * Initializating Document pool");
        this.documents = new TreeMap();
        ErrorBrowserEditor.log("[Done]");
    }

    public void newDocument(String string, String string2) {
        EbeDocument ebeDocument = new EbeDocument();
        ebeDocument.setPath(string);
        ebeDocument.setDocumentInfo(string2);
        ebeDocument.setValue(string2);
        this.documents.put(ebeDocument.getValue(), ebeDocument);
        ErrorBrowserEditor.log("[Created new document: " + string2 + "]");
    }

    public void loadDocument(String string) {
        EbeDocument ebeDocument = new EbeDocument();
        ebeDocument.setPath(string);
        ebeDocument.load();
        this.documents.put(ebeDocument.getValue(), ebeDocument);
        ErrorBrowserEditor.log("[Document " + string + " loaded]");
        ErrorBrowserEditor.log("   * " + ebeDocument.getNodes().size() + " definitions loaded");
    }

    public void removeDocument(String string) {
        this.documents.remove(string);
        ErrorBrowserEditor.log("[Document " + string + " removed]");
    }

    public void removeAll() {
        this.documents.clear();
        ErrorBrowserEditor.log("[Document list cleaned]");
    }

    public void deleteDocument(String string) {
        EbeDocument ebeDocument = this.documents.get(string);
        File file = new File(ebeDocument.getPath());
        if (file.delete()) {
            this.documents.remove(string);
            ErrorBrowserEditor.log("[File " + string + " successfully deleted from the Hard Disk]");
        } else {
            ErrorBrowserEditor.log("[ATENTION: File " + string + " *cannot* be deleted from the Hard Disk, please check permissions]");
        }
    }

    private void addFileList(ArrayList<File> arrayList) {
        ErrorBrowserEditor.log("Adding Files...");
        for (File file : arrayList) {
            this.loadDocument(file.getAbsolutePath());
        }
        ErrorBrowserEditor.log("[Done]");
    }

    public void addDefaults() {
        ErrorBrowserEditor.log("[Adding default directories]");
        XmlSeeker xmlSeeker = new XmlSeeker();
        String string = System.getProperty("ACS.modroot");
        String string2 = System.getProperty("ACS.introot");
        String string3 = System.getProperty("ACS.acsroot");
        xmlSeeker.addDir(string + File.separator + "idl");
        xmlSeeker.addDir(string2 + File.separator + "idl");
        xmlSeeker.addDir(string3 + File.separator + "idl");
        this.addFileList(xmlSeeker.getXmls("Alma/ACSError ACSError.xsd"));
    }

    public void addDirectory(String string) {
        ErrorBrowserEditor.log("[Adding " + string + " directory]");
        XmlSeeker xmlSeeker = new XmlSeeker();
        xmlSeeker.addDir(string);
        this.addFileList(xmlSeeker.getXmls("Alma/ACSError ACSError.xsd"));
    }

    public TreeMap<String, EbeDocument> getDocuments() {
        return this.documents;
    }
}

