/*
 * Decompiled with CFR 0.152.
 */
package javax.infobus;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.infobus.DefaultController;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusDataController;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRequestedEvent;
import javax.infobus.InfoBusItemRevokedEvent;
import javax.infobus.InfoBusMember;
import javax.infobus.InfoBusMembershipException;
import javax.infobus.InfoBusPolicyHelper;
import javax.infobus.PrioritizedDCList;
import javax.infobus.StaleInfoBusException;

public final class InfoBus
implements PropertyChangeListener {
    static final byte Copyright_1997_1998_Lotus_Development_Corporation_All_Rights_Reserved = 1;
    private static Vector sm_infoBusList = new Vector();
    private static InfoBusPolicyHelper sm_IBPolicy;
    private static Object sm_syncLock;
    private Object m_syncLock;
    static final boolean DEBUG_OUTPUT = false;
    public static final String MIME_TYPE_IMMEDIATE_ACCESS = "application/x-java-infobus;class=javax.infobus.ImmediateAccess";
    public static final String MIME_TYPE_ARRAY_ACCESS = "application/x-java-infobus;class=javax.infobus.ArrayAccess";
    public static final String MIME_TYPE_RESHAPEABLEARRAY_ACCESS = "application/x-java-infobus;class=javax.infobus.ReshapeableArrayAccess";
    public static final String MIME_TYPE_ROWSET_ACCESS = "application/x-java-infobus;class=javax.infobus.RowsetAccess";
    public static final String MIME_TYPE_SCROLLABLEROWSET_ACCESS = "application/x-java-infobus;class=javax.infobus.ScrollableRowsetAccess";
    public static final String MIME_TYPE_DB_ACCESS = "application/x-java-infobus;class=javax.infobus.DbAccess";
    public static final String MIME_TYPE_COLLECTION = "application/x-java-infobus;class=java.util.Collection";
    public static final String MIME_TYPE_MAP = "application/x-java-infobus;class=java.util.Map";
    public static final String MIME_TYPE_SET = "application/x-java-infobus;class=java.util.Set";
    public static final String MIME_TYPE_LIST = "application/x-java-infobus;class=java.util.List";
    public static final String MIME_TYPE_ANY_ACCESS = "application/x-java-infobus;class=javax.infobus.DataItem";
    public static final int MONITOR_PRIORITY = 6;
    public static final int VERY_HIGH_PRIORITY = 5;
    public static final int HIGH_PRIORITY = 4;
    public static final int MEDIUM_PRIORITY = 3;
    public static final int LOW_PRIORITY = 2;
    public static final int VERY_LOW_PRIORITY = 1;
    static final int DEFAULT_CONTROLLER_PRIORITY = 0;
    private String m_busID;
    private Vector m_memberList;
    private Vector m_producerList;
    private Vector m_consumerList;
    private int m_openCount;
    private PrioritizedDCList m_controllerList;
    private boolean m_addedControllers;
    private InfoBusDataController m_defaultControl;

    private InfoBus(String string) {
        InfoBus.checkPolicy();
        this.m_busID = string;
        this.m_memberList = new Vector();
        this.m_producerList = new Vector();
        this.m_consumerList = new Vector();
        this.m_syncLock = new Object();
        this.m_controllerList = new PrioritizedDCList(1, 1, this);
        this.m_defaultControl = new DefaultController(this);
        this.m_defaultControl.setProducerList(this.m_producerList);
        this.m_defaultControl.setConsumerList(this.m_consumerList);
        try {
            this.m_controllerList.addDataController(this.m_defaultControl, 0);
        }
        catch (InfoBusMembershipException infoBusMembershipException) {}
        this.m_addedControllers = false;
    }

    private static void checkPolicy() {
        Object object = sm_syncLock;
        synchronized (object) {
            if (sm_IBPolicy == null) {
                String string = "javax.infobus.DefaultPolicy";
                try {
                    string = System.getProperty("javax.infobus.InfoBusPolicy", "javax.infobus.DefaultPolicy");
                }
                catch (SecurityException securityException) {}
                try {
                    Class<?> clazz = Class.forName(string);
                    sm_IBPolicy = (InfoBusPolicyHelper)clazz.newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Fatal Error Initializing InfoBusPolicy  in javax.infobus.InfoBus:" + exception);
                    throw new MissingResourceException("Fatal Error Initializing javax.infobus.InfoBus", string, "javax.infobus.InfoBusPolicy");
                }
            }
            return;
        }
    }

    void checkStale() {
        Object object = this.m_syncLock;
        synchronized (object) {
            if (!sm_infoBusList.contains(this)) {
                throw new StaleInfoBusException(" Attempt to use stale  InfoBus, busName = " + this.getName());
            }
            return;
        }
    }

    public String getName() {
        return this.m_busID;
    }

    public static InfoBus get(Component component) {
        InfoBus.checkPolicy();
        String string = sm_IBPolicy.generateDefaultName(component);
        sm_IBPolicy.canGet(string);
        InfoBus infoBus = InfoBus.get(string);
        return infoBus;
    }

    public static InfoBus get(String string) {
        Object object = sm_syncLock;
        synchronized (object) {
            InfoBus infoBus;
            try {
                if (string.charAt(0) == '-') {
                    throw new IllegalArgumentException("InfoBus names must not begin with the dash ( - ) character");
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new IllegalArgumentException("The parameter to InfoBus.get(String) must not be the empty string.");
            }
            if (string.indexOf(42) != -1) {
                throw new IllegalArgumentException("InfoBus names must not contain the asterisk ( * ) character");
            }
            InfoBus.checkPolicy();
            sm_IBPolicy.canGet(string);
            int n = 0;
            while (n < sm_infoBusList.size()) {
                infoBus = (InfoBus)sm_infoBusList.elementAt(n);
                if (infoBus.getName().equals(string)) {
                    infoBus.incrementOpenCount();
                    InfoBus infoBus2 = infoBus;
                    Object var3_6 = null;
                    return infoBus2;
                }
                ++n;
            }
            infoBus = new InfoBus(string);
            sm_infoBusList.addElement(infoBus);
            infoBus.incrementOpenCount();
            InfoBus infoBus3 = infoBus;
            Object var3_7 = null;
            return infoBus3;
        }
    }

    private void incrementOpenCount() {
        ++this.m_openCount;
    }

    private void decrementOpenCount() {
        --this.m_openCount;
        if (this.m_openCount < 0) {
            this.m_openCount = 0;
        }
    }

    public void release() {
        Object object = this.m_syncLock;
        synchronized (object) {
            this.decrementOpenCount();
            this.freeUnused();
            return;
        }
    }

    public void join(InfoBusMember infoBusMember) throws PropertyVetoException {
        Object object = this.m_syncLock;
        synchronized (object) {
            this.checkStale();
            sm_IBPolicy.canJoin(this, infoBusMember);
            try {
                infoBusMember.setInfoBus(this);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.freeUnused();
                throw propertyVetoException;
            }
            return;
        }
    }

    public void register(InfoBusMember infoBusMember) {
        Object object = this.m_syncLock;
        synchronized (object) {
            this.checkStale();
            sm_IBPolicy.canRegister(this, infoBusMember);
            if (!this.m_memberList.contains(infoBusMember)) {
                infoBusMember.addInfoBusPropertyListener(this);
                this.m_memberList.addElement(infoBusMember);
            }
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && string.equals("InfoBus")) {
            sm_IBPolicy.canPropertyChange(this, propertyChangeEvent);
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object == object2) {
                return;
            }
            if (object == this) {
                InfoBusMember infoBusMember = (InfoBusMember)propertyChangeEvent.getSource();
                infoBusMember.removeInfoBusPropertyListener(this);
                this.m_memberList.removeElement(infoBusMember);
                this.freeUnused();
            }
        }
    }

    private void freeUnused() {
        Object object = this.m_syncLock;
        synchronized (object) {
            if (this.m_openCount > 0) {
                Object var2_2 = null;
                return;
            }
            if (this.m_memberList.isEmpty() && this.m_producerList.isEmpty() && this.m_consumerList.isEmpty() && !this.m_addedControllers) {
                Object object2 = sm_syncLock;
                synchronized (object2) {
                    sm_infoBusList.removeElement(this);
                }
            }
            return;
        }
    }

    public void leave(InfoBusMember infoBusMember) throws PropertyVetoException {
        Object object = this.m_syncLock;
        synchronized (object) {
            if (!this.m_memberList.removeElement(infoBusMember)) {
                Object var3_3 = null;
                return;
            }
            infoBusMember.removeInfoBusPropertyListener(this);
            try {
                infoBusMember.setInfoBus(null);
            }
            catch (PropertyVetoException propertyVetoException) {
                infoBusMember.addInfoBusPropertyListener(this);
                this.m_memberList.addElement(infoBusMember);
                throw propertyVetoException;
            }
            this.freeUnused();
            return;
        }
    }

    public void addDataController(InfoBusDataController infoBusDataController, int n) throws InfoBusMembershipException {
        Object object = this.m_syncLock;
        synchronized (object) {
            this.checkStale();
            if (infoBusDataController == null) {
                throw new NullPointerException("InfoBus.addDataController cannot accept null as parameter");
            }
            sm_IBPolicy.canAddDataController(this, infoBusDataController, n);
            this.m_controllerList.addDataController(infoBusDataController, n);
            Vector vector = (Vector)this.m_producerList.clone();
            Vector vector2 = (Vector)this.m_consumerList.clone();
            infoBusDataController.setProducerList(vector);
            infoBusDataController.setConsumerList(vector2);
            this.m_addedControllers = true;
            return;
        }
    }

    public void removeDataController(InfoBusDataController infoBusDataController) {
        Object object = this.m_syncLock;
        synchronized (object) {
            this.m_controllerList.removeDataController(infoBusDataController);
            this.freeUnused();
            return;
        }
    }

    public void addDataProducer(InfoBusDataProducer infoBusDataProducer) {
        Object object = this.m_syncLock;
        synchronized (object) {
            if (infoBusDataProducer == null) {
                throw new NullPointerException("InfoBus.addDataProducer cannot accept null as parameter");
            }
            this.checkStale();
            sm_IBPolicy.canAddDataProducer(this, infoBusDataProducer);
            if (!this.m_producerList.contains(infoBusDataProducer)) {
                this.m_producerList.addElement(infoBusDataProducer);
                if (this.m_addedControllers) {
                    Enumeration enumeration = this.m_controllerList.elements();
                    while (enumeration.hasMoreElements()) {
                        InfoBusDataController infoBusDataController = (InfoBusDataController)enumeration.nextElement();
                        infoBusDataController.addDataProducer(infoBusDataProducer);
                    }
                }
            }
            return;
        }
    }

    public void removeDataProducer(InfoBusDataProducer infoBusDataProducer) {
        Object object = this.m_syncLock;
        synchronized (object) {
            this.m_producerList.removeElement(infoBusDataProducer);
            if (this.m_addedControllers) {
                Enumeration enumeration = this.m_controllerList.elements();
                while (enumeration.hasMoreElements()) {
                    InfoBusDataController infoBusDataController = (InfoBusDataController)enumeration.nextElement();
                    infoBusDataController.removeDataProducer(infoBusDataProducer);
                }
            }
            this.freeUnused();
            return;
        }
    }

    public void addDataConsumer(InfoBusDataConsumer infoBusDataConsumer) {
        Object object = this.m_syncLock;
        synchronized (object) {
            if (infoBusDataConsumer == null) {
                throw new NullPointerException("InfoBus.addDataConsumer cannot accept null as parameter");
            }
            this.checkStale();
            sm_IBPolicy.canAddDataConsumer(this, infoBusDataConsumer);
            if (!this.m_consumerList.contains(infoBusDataConsumer)) {
                this.m_consumerList.addElement(infoBusDataConsumer);
                if (this.m_addedControllers) {
                    Enumeration enumeration = this.m_controllerList.elements();
                    while (enumeration.hasMoreElements()) {
                        InfoBusDataController infoBusDataController = (InfoBusDataController)enumeration.nextElement();
                        infoBusDataController.addDataConsumer(infoBusDataConsumer);
                    }
                }
            }
            return;
        }
    }

    public void removeDataConsumer(InfoBusDataConsumer infoBusDataConsumer) {
        Object object = this.m_syncLock;
        synchronized (object) {
            this.m_consumerList.removeElement(infoBusDataConsumer);
            if (this.m_addedControllers) {
                Enumeration enumeration = this.m_controllerList.elements();
                while (enumeration.hasMoreElements()) {
                    InfoBusDataController infoBusDataController = (InfoBusDataController)enumeration.nextElement();
                    infoBusDataController.removeDataConsumer(infoBusDataConsumer);
                }
            }
            this.freeUnused();
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fireItemAvailable(String var1_1, DataFlavor[] var2_2, InfoBusDataProducer var3_3) {
        block1: {
            InfoBus.sm_IBPolicy.canFireItemAvailable(this, var1_1, var3_3);
            if (!this.m_addedControllers) break block1;
            var4_4 = false;
            var5_5 = this.m_controllerList.getDCclone();
            var6_6 = var5_5.size();
            var7_7 = 0;
            if (true) ** GOTO lbl12
            do {
                var8_8 = (InfoBusDataController)var5_5.elementAt(var7_7);
                var4_4 = var8_8.fireItemAvailable(var1_1, var2_2, var3_3);
                ++var7_7;
lbl12:
                // 2 sources

                if (var7_7 >= var6_6) return;
            } while (!var4_4);
            return;
        }
        this.m_defaultControl.fireItemAvailable(var1_1, var2_2, var3_3);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fireItemRevoked(String var1_1, InfoBusDataProducer var2_2) {
        block1: {
            InfoBus.sm_IBPolicy.canFireItemRevoked(this, var1_1, var2_2);
            if (!this.m_addedControllers) break block1;
            var3_3 = false;
            var4_4 = this.m_controllerList.getDCclone();
            var5_5 = var4_4.size();
            var6_6 = 0;
            if (true) ** GOTO lbl12
            do {
                var7_7 = (InfoBusDataController)var4_4.elementAt(var6_6);
                var3_3 = var7_7.fireItemRevoked(var1_1, var2_2);
                ++var6_6;
lbl12:
                // 2 sources

                if (var6_6 >= var5_5) return;
            } while (!var3_3);
            return;
        }
        this.m_defaultControl.fireItemRevoked(var1_1, var2_2);
    }

    public Object findDataItem(String string, DataFlavor[] dataFlavorArray, InfoBusDataConsumer infoBusDataConsumer) {
        sm_IBPolicy.canRequestItem(this, string, infoBusDataConsumer);
        Vector vector = new Vector(1, 1);
        if (this.m_addedControllers) {
            boolean bl = false;
            PrioritizedDCList prioritizedDCList = (PrioritizedDCList)this.m_controllerList.clone();
            int n = prioritizedDCList.size();
            int n2 = 0;
            while (!bl && n2 < n) {
                InfoBusDataController infoBusDataController = prioritizedDCList.controllerAt(n2);
                int n3 = prioritizedDCList.priorityAt(n2);
                bl = infoBusDataController.findDataItem(string, dataFlavorArray, infoBusDataConsumer, vector);
                if (n3 == 6) {
                    vector.removeAllElements();
                    bl = false;
                } else {
                    bl = bl || !vector.isEmpty();
                }
                ++n2;
            }
        } else {
            this.m_defaultControl.findDataItem(string, dataFlavorArray, infoBusDataConsumer, vector);
        }
        if (vector.isEmpty()) {
            return null;
        }
        return vector.elementAt(0);
    }

    public Object[] findMultipleDataItems(String string, DataFlavor[] dataFlavorArray, InfoBusDataConsumer infoBusDataConsumer) {
        Object[] objectArray;
        int n;
        sm_IBPolicy.canRequestItem(this, string, infoBusDataConsumer);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (this.m_addedControllers) {
            n = 0;
            objectArray = (Object[])this.m_controllerList.clone();
            int n2 = objectArray.size();
            int n3 = 0;
            while (n == 0 && n3 < n2) {
                InfoBusDataController infoBusDataController = objectArray.controllerAt(n3);
                int n4 = objectArray.priorityAt(n3);
                n = infoBusDataController.findMultipleDataItems(string, dataFlavorArray, infoBusDataConsumer, vector2) ? 1 : 0;
                if (n4 != 6) {
                    this.catNoDups(vector, vector2);
                } else {
                    n = 0;
                }
                vector2.removeAllElements();
                ++n3;
            }
        } else {
            this.m_defaultControl.findMultipleDataItems(string, dataFlavorArray, infoBusDataConsumer, vector2);
            this.catNoDups(vector, vector2);
        }
        if (vector.isEmpty()) {
            return null;
        }
        n = vector.size();
        objectArray = new Object[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void catNoDups(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (vector.contains(e)) continue;
            vector.addElement(e);
        }
    }

    public Object findDataItem(String string, DataFlavor[] dataFlavorArray, InfoBusDataConsumer infoBusDataConsumer, InfoBusDataProducer infoBusDataProducer) {
        sm_IBPolicy.canRequestItem(this, string, infoBusDataConsumer);
        InfoBusItemRequestedEvent infoBusItemRequestedEvent = new InfoBusItemRequestedEvent(string, dataFlavorArray, infoBusDataConsumer);
        if (infoBusDataProducer != null) {
            infoBusDataProducer.dataItemRequested(infoBusItemRequestedEvent);
        }
        Object object = infoBusItemRequestedEvent.getDataItem();
        return object;
    }

    public Object findDataItem(String string, DataFlavor[] dataFlavorArray, InfoBusDataConsumer infoBusDataConsumer, Vector vector) {
        sm_IBPolicy.canRequestItem(this, string, infoBusDataConsumer);
        Vector vector2 = (Vector)vector.clone();
        InfoBusItemRequestedEvent infoBusItemRequestedEvent = new InfoBusItemRequestedEvent(string, dataFlavorArray, infoBusDataConsumer);
        Object object = null;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements() && object == null) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            ((InfoBusDataProducer)e).dataItemRequested(infoBusItemRequestedEvent);
            object = infoBusItemRequestedEvent.getDataItem();
        }
        return object;
    }

    public void fireItemAvailable(String string, DataFlavor[] dataFlavorArray, InfoBusDataProducer infoBusDataProducer, InfoBusDataConsumer infoBusDataConsumer) {
        sm_IBPolicy.canFireItemAvailable(this, string, infoBusDataProducer);
        InfoBusItemAvailableEvent infoBusItemAvailableEvent = new InfoBusItemAvailableEvent(string, dataFlavorArray, infoBusDataProducer);
        if (infoBusDataConsumer != null) {
            infoBusDataConsumer.dataItemAvailable(infoBusItemAvailableEvent);
        }
    }

    public void fireItemAvailable(String string, DataFlavor[] dataFlavorArray, InfoBusDataProducer infoBusDataProducer, Vector vector) {
        sm_IBPolicy.canFireItemAvailable(this, string, infoBusDataProducer);
        Vector vector2 = (Vector)vector.clone();
        InfoBusItemAvailableEvent infoBusItemAvailableEvent = new InfoBusItemAvailableEvent(string, dataFlavorArray, infoBusDataProducer);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            ((InfoBusDataConsumer)e).dataItemAvailable(infoBusItemAvailableEvent);
        }
    }

    public void fireItemRevoked(String string, InfoBusDataProducer infoBusDataProducer, InfoBusDataConsumer infoBusDataConsumer) {
        sm_IBPolicy.canFireItemRevoked(this, string, infoBusDataProducer);
        InfoBusItemRevokedEvent infoBusItemRevokedEvent = new InfoBusItemRevokedEvent(string, infoBusDataProducer);
        if (infoBusDataConsumer != null) {
            infoBusDataConsumer.dataItemRevoked(infoBusItemRevokedEvent);
        }
    }

    public void fireItemRevoked(String string, InfoBusDataProducer infoBusDataProducer, Vector vector) {
        sm_IBPolicy.canFireItemRevoked(this, string, infoBusDataProducer);
        Vector vector2 = (Vector)vector.clone();
        InfoBusItemRevokedEvent infoBusItemRevokedEvent = new InfoBusItemRevokedEvent(string, infoBusDataProducer);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            ((InfoBusDataConsumer)e).dataItemRevoked(infoBusItemRevokedEvent);
        }
    }

    static {
        sm_syncLock = new Object();
    }
}

