/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.definition.impl;

import alma.alarmsystem.CERNAlarmService;
import cern.laser.client.LaserConnectionException;
import cern.laser.client.LaserException;
import cern.laser.client.impl.common.AlarmServiceSingleton;
import cern.laser.definition.AdminUser;
import cern.laser.definition.AdminUserHandler;
import cern.laser.definition.LaserDefinitionException;
import cern.laser.definition.impl.AdminUserImpl;
import java.util.Collection;

public class AdminUserHandlerImpl
extends AdminUserHandler {
    private CERNAlarmService alarmService;

    public AdminUserHandlerImpl() throws LaserException, LaserConnectionException {
        try {
            this.alarmService = AlarmServiceSingleton.getInstance();
        }
        catch (Throwable throwable) {
            throw new LaserConnectionException("Error getting the alarm service", throwable);
        }
    }

    @Override
    public Collection getUsers() throws LaserDefinitionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AdminUser createUser(String string, String string2) throws LaserDefinitionException {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        try {
            String string3 = this.alarmService.createAdminUser(string, string2);
            return new AdminUserImpl(string3);
        }
        catch (Exception exception) {
            throw new LaserDefinitionException("unable to create user : " + string, exception);
        }
    }

    @Override
    public AdminUser loginUser(String string, String string2) throws LaserDefinitionException {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        try {
            return new AdminUserImpl(this.alarmService.loginAdminUser(string, string2));
        }
        catch (Exception exception) {
            throw new LaserDefinitionException("unable to login user " + string, exception);
        }
    }

    @Override
    public void removeUser(String string) throws LaserDefinitionException {
        throw new UnsupportedOperationException();
    }

    private Object getDefinitionServiceSessionEJB() throws Exception {
        throw new UnsupportedOperationException();
    }
}

