/*
 * Decompiled with CFR 0.152.
 */
package org.omg.AVStreams;

import java.util.Hashtable;
import org.omg.AVStreams.InvalidPosition;
import org.omg.AVStreams.InvalidPositionHelper;
import org.omg.AVStreams.MediaControl;
import org.omg.AVStreams.MediaControlHelper;
import org.omg.AVStreams.MediaControlOperations;
import org.omg.AVStreams.MediaControlPackage.PostionKeyNotSupported;
import org.omg.AVStreams.MediaControlPackage.PostionKeyNotSupportedHelper;
import org.omg.AVStreams.Position;
import org.omg.AVStreams.PositionHelper;
import org.omg.AVStreams.PositionKey;
import org.omg.AVStreams.PositionKeyHelper;
import org.omg.AVStreams.PositionOrigin;
import org.omg.AVStreams.PositionOriginHelper;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class MediaControlPOA
extends Servant
implements InvokeHandler,
MediaControlOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:omg.org/AVStreams/MediaControl:1.0"};

    public MediaControl _this() {
        return MediaControlHelper.narrow(this._this_object());
    }

    public MediaControl _this(ORB oRB) {
        return MediaControlHelper.narrow(this._this_object(oRB));
    }

    @Override
    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                try {
                    Position position = PositionHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.stop(position);
                }
                catch (InvalidPosition invalidPosition) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPositionHelper.write(outputStream, invalidPosition);
                }
                break;
            }
            case 1: {
                try {
                    Position position = PositionHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.pause(position);
                }
                catch (InvalidPosition invalidPosition) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPositionHelper.write(outputStream, invalidPosition);
                }
                break;
            }
            case 2: {
                try {
                    Position position = PositionHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.resume(position);
                }
                catch (InvalidPosition invalidPosition) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPositionHelper.write(outputStream, invalidPosition);
                }
                break;
            }
            case 3: {
                try {
                    Position position = PositionHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.set_media_position(position);
                }
                catch (InvalidPosition invalidPosition) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPositionHelper.write(outputStream, invalidPosition);
                }
                catch (PostionKeyNotSupported postionKeyNotSupported) {
                    outputStream = responseHandler.createExceptionReply();
                    PostionKeyNotSupportedHelper.write(outputStream, postionKeyNotSupported);
                }
                break;
            }
            case 4: {
                try {
                    Position position = PositionHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.start(position);
                }
                catch (InvalidPosition invalidPosition) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidPositionHelper.write(outputStream, invalidPosition);
                }
                break;
            }
            case 5: {
                try {
                    PositionOrigin positionOrigin = PositionOriginHelper.read(inputStream);
                    PositionKey positionKey = PositionKeyHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    PositionHelper.write(outputStream, this.get_media_position(positionOrigin, positionKey));
                    break;
                }
                catch (PostionKeyNotSupported postionKeyNotSupported) {
                    outputStream = responseHandler.createExceptionReply();
                    PostionKeyNotSupportedHelper.write(outputStream, postionKeyNotSupported);
                }
            }
        }
        return outputStream;
    }

    @Override
    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    static {
        m_opsHash.put("stop", new Integer(0));
        m_opsHash.put("pause", new Integer(1));
        m_opsHash.put("resume", new Integer(2));
        m_opsHash.put("set_media_position", new Integer(3));
        m_opsHash.put("start", new Integer(4));
        m_opsHash.put("get_media_position", new Integer(5));
    }
}

