/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.tracing;

import java.util.Hashtable;
import org.jacorb.util.tracing.Request;
import org.jacorb.util.tracing.TraceData;
import org.jacorb.util.tracing.TraceTreeNode;
import org.jacorb.util.tracing.TracingServicePOA;
import org.jacorb.util.tracing.TracingServicePackage.NoSuchRequestId;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class TracingServiceImpl
extends TracingServicePOA {
    private int pointIds = 0;
    private Hashtable traces = new Hashtable();

    @Override
    public synchronized int get_id() {
        return this.pointIds++;
    }

    @Override
    public TraceData getTrace(Request request) throws NoSuchRequestId {
        if (request.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - getTrace()");
            throw new NoSuchRequestId();
        }
        System.out.println("getTrace for tracer: " + request.originator + ", rid: " + request.rid);
        Long l = new Long(request.rid);
        TraceTreeNode traceTreeNode = (TraceTreeNode)this.traces.get(l);
        if (traceTreeNode == null) {
            return new TraceData(new TraceData[0], 0, "", 0L, 0L);
        }
        TraceData traceData = new TraceData(new TraceData[traceTreeNode.subtraces.size()], traceTreeNode.tracer_id, traceTreeNode.operation, traceTreeNode.client_time, traceTreeNode.server_time);
        for (int i = 0; i < traceTreeNode.subtraces.size(); ++i) {
            Request request2 = (Request)traceTreeNode.subtraces.elementAt(i);
            traceData.subtrace[i] = this.getTrace(request2);
        }
        return traceData;
    }

    @Override
    public void logTraceAtPoint(Request request, String string, long l, long l2) throws NoSuchRequestId {
        if (request.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - logTraceAtPoint()");
            throw new NoSuchRequestId();
        }
        System.out.println("logTraceAtPoint for tracer: " + request.originator + ", rid: " + request.rid);
        Long l3 = new Long(request.rid);
        TraceTreeNode traceTreeNode = (TraceTreeNode)this.traces.get(l3);
        if (traceTreeNode == null) {
            traceTreeNode = new TraceTreeNode(request.originator);
            this.traces.put(l3, traceTreeNode);
        }
        traceTreeNode.operation = string;
        traceTreeNode.client_time = l;
        traceTreeNode.server_time = l2;
    }

    @Override
    public void registerSubTrace(Request request, Request request2) throws NoSuchRequestId {
        System.out.println("registerSubTrace for tracer: " + request.originator + ", rid: " + request.rid);
        if (request.originator >= this.pointIds || request2.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - registerSubTrace()");
            throw new NoSuchRequestId();
        }
        Long l = new Long(request.rid);
        TraceTreeNode traceTreeNode = (TraceTreeNode)this.traces.get(l);
        if (traceTreeNode == null) {
            traceTreeNode = new TraceTreeNode(request.originator);
            this.traces.put(l, traceTreeNode);
        }
        traceTreeNode.subtraces.addElement(request2);
    }

    public static void main(String[] stringArray) {
        ORB oRB = ORB.init(stringArray, null);
        try {
            POA pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"));
            pOA.the_POAManager().activate();
            Object object = pOA.servant_to_reference(new TracingServiceImpl());
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
            namingContextExt.bind(namingContextExt.to_name("tracing.service"), object);
            pOA.the_POAManager().activate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        oRB.run();
    }
}

