/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;
import org.jacorb.trading.util.PropUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTrading.LookupPackage.HowManyProps;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Property;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;

public class SourceAdapter
implements PropertySource {
    private Hashtable m_propTable;
    private Hashtable m_values;
    private Hashtable m_propValues;
    private Object m_object;
    private Property[] m_props;
    private ORB orb;

    protected SourceAdapter() {
    }

    public SourceAdapter(Object object, Property[] propertyArray) {
        this.orb = ((ObjectImpl)object)._orb();
        this.m_object = object;
        this.m_props = propertyArray;
        this.m_propTable = new Hashtable();
        this.m_values = new Hashtable();
        this.m_propValues = new Hashtable();
        for (int i = 0; i < propertyArray.length; ++i) {
            this.m_propTable.put(propertyArray[i].name, propertyArray[i]);
        }
    }

    public Object getObject() {
        return this.m_object;
    }

    public Property[] getProperties() {
        return this.m_props;
    }

    public Property[] getProperties(SpecifiedProps specifiedProps) {
        Property[] propertyArray = null;
        if (specifiedProps.discriminator() == HowManyProps.all) {
            Vector<Property> vector = new Vector<Property>();
            for (int i = 0; i < this.m_props.length; ++i) {
                Any any = this.getPropertyValue(this.m_props[i].name);
                if (any == null) continue;
                vector.addElement(new Property(this.m_props[i].name, any));
            }
            propertyArray = new Property[vector.size()];
            vector.copyInto(propertyArray);
        } else if (specifiedProps.discriminator() == HowManyProps.some) {
            String[] stringArray = specifiedProps.prop_names();
            Vector<Property> vector = new Vector<Property>();
            for (int i = 0; i < stringArray.length; ++i) {
                Any any = this.getPropertyValue(stringArray[i]);
                if (any == null) continue;
                vector.addElement(new Property(stringArray[i], any));
            }
            propertyArray = new Property[vector.size()];
            vector.copyInto(propertyArray);
        } else if (specifiedProps.discriminator() == HowManyProps.none) {
            propertyArray = new Property[]{};
        }
        return propertyArray;
    }

    @Override
    public boolean exists(String string) {
        return this.m_propTable.containsKey(string);
    }

    @Override
    public Value getValue(String string) {
        Value value = null;
        java.lang.Object v = this.m_values.get(string);
        if (v == null) {
            Property property = (Property)this.m_propTable.get(string);
            if (property == null) {
                return null;
            }
            Any any = this.getPropertyValue(string);
            if (any == null) {
                return null;
            }
            this.m_propValues.put(string, any);
            try {
                TypeCode typeCode = any.type();
                while (typeCode.kind() == TCKind.tk_alias) {
                    typeCode = typeCode.content_type();
                }
                TCKind tCKind = typeCode.kind();
                if (tCKind == TCKind.tk_sequence) {
                    return null;
                }
                switch (tCKind.value()) {
                    case 2: {
                        short s = any.extract_short();
                        value = ValueFactory.createShort(s);
                        break;
                    }
                    case 3: {
                        int n = any.extract_long();
                        value = ValueFactory.createLong(n);
                        break;
                    }
                    case 4: {
                        short s = any.extract_short();
                        value = ValueFactory.createUShort(s);
                        break;
                    }
                    case 5: {
                        long l = any.extract_ulong();
                        value = ValueFactory.createULong(l);
                        break;
                    }
                    case 6: {
                        float f = any.extract_float();
                        value = ValueFactory.createFloat(f);
                        break;
                    }
                    case 7: {
                        double d = any.extract_double();
                        value = ValueFactory.createDouble(d);
                        break;
                    }
                    case 8: {
                        boolean bl = any.extract_boolean();
                        value = ValueFactory.createBoolean(bl);
                        break;
                    }
                    case 9: {
                        char c = any.extract_char();
                        value = ValueFactory.createChar(c);
                        break;
                    }
                    case 18: {
                        String string2 = any.extract_string();
                        value = ValueFactory.createString(string2);
                    }
                }
            }
            catch (BadKind badKind) {
                throw new RuntimeException();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new RuntimeException();
            }
            this.m_values.put(string, value);
        } else if (v instanceof Value) {
            value = (Value)v;
        }
        return value;
    }

    @Override
    public Value[] getSequenceValues(String string) {
        Value[] valueArray = null;
        java.lang.Object v = this.m_values.get(string);
        if (v == null) {
            Property property = (Property)this.m_propTable.get(string);
            if (property == null) {
                return null;
            }
            Any any = this.getPropertyValue(string);
            if (any == null) {
                return null;
            }
            this.m_propValues.put(string, any);
            try {
                TypeCode typeCode = any.type();
                while (typeCode.kind() == TCKind.tk_alias) {
                    typeCode = typeCode.content_type();
                }
                if (typeCode.kind() != TCKind.tk_sequence) {
                    return null;
                }
                typeCode = typeCode.content_type();
                TCKind tCKind = typeCode.kind();
                DynAny dynAny = DynAnyFactoryHelper.narrow(this.orb.resolve_initial_references("DynAnyFactory")).create_dyn_any(any);
                DynSequence dynSequence = DynSequenceHelper.narrow(dynAny);
                int n = dynSequence.get_length();
                valueArray = new Value[n];
                switch (tCKind.value()) {
                    case 2: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createShort(dynSequence.get_short());
                            dynSequence.next();
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createLong(dynSequence.get_long());
                            dynSequence.next();
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createUShort(dynSequence.get_ushort());
                            dynSequence.next();
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createULong(dynSequence.get_ulong());
                            dynSequence.next();
                        }
                        break;
                    }
                    case 6: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createFloat(dynSequence.get_float());
                            dynSequence.next();
                        }
                        break;
                    }
                    case 7: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createDouble(dynSequence.get_double());
                            dynSequence.next();
                        }
                        break;
                    }
                    case 8: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createBoolean(dynSequence.get_boolean());
                            dynSequence.next();
                        }
                        break;
                    }
                    case 9: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createChar(dynSequence.get_char());
                            dynSequence.next();
                        }
                        break;
                    }
                    case 18: {
                        for (int i = 0; i < n; ++i) {
                            valueArray[i] = ValueFactory.createString(dynSequence.get_string());
                            dynSequence.next();
                        }
                        break;
                    }
                }
                dynAny.destroy();
            }
            catch (BadKind badKind) {
                throw new RuntimeException();
            }
            catch (TypeMismatch typeMismatch) {
                throw new RuntimeException();
            }
            catch (InvalidValue invalidValue) {
                throw new RuntimeException();
            }
            catch (InconsistentTypeCode inconsistentTypeCode) {
                throw new RuntimeException();
            }
            catch (InvalidName invalidName) {
                throw new RuntimeException();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new RuntimeException();
            }
            this.m_values.put(string, valueArray);
        } else if (v instanceof Value[]) {
            valueArray = (Value[])v;
        }
        return valueArray;
    }

    public Any getPropertyValue(String string) {
        Any any = (Any)this.m_propValues.get(string);
        if (any == null) {
            Property property = (Property)this.m_propTable.get(string);
            if (property == null) {
                return null;
            }
            any = PropUtil.getPropertyValue(property);
            if (any != null) {
                this.m_propValues.put(string, any);
            }
        }
        return any;
    }
}

