/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Hashtable;
import org.jacorb.trading.constraint.PropertySchema;
import org.jacorb.trading.constraint.ValueType;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class SchemaAdapter
implements PropertySchema {
    private Hashtable m_props;
    private TypeStruct m_type;

    private SchemaAdapter() {
    }

    public SchemaAdapter(TypeStruct typeStruct) {
        this.m_type = typeStruct;
        this.m_props = new Hashtable();
        try {
            for (int i = 0; i < typeStruct.props.length; ++i) {
                Object object;
                PropStruct propStruct = typeStruct.props[i];
                boolean bl = false;
                TCKind tCKind = propStruct.value_type.kind();
                if (tCKind == TCKind.tk_sequence) {
                    bl = true;
                    object = propStruct.value_type.content_type();
                    tCKind = ((TypeCode)object).kind();
                }
                int n = this.convertKind(tCKind);
                object = new ValueType(n, bl);
                this.m_props.put(typeStruct.props[i].name, object);
            }
        }
        catch (BadKind badKind) {
            throw new RuntimeException();
        }
    }

    @Override
    public boolean exists(String string) {
        return this.m_props.containsKey(string);
    }

    @Override
    public ValueType getPropertyType(String string) {
        return (ValueType)this.m_props.get(string);
    }

    protected int convertKind(TCKind tCKind) {
        int n;
        switch (tCKind.value()) {
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 8: {
                n = 0;
                break;
            }
            case 9: {
                n = 7;
                break;
            }
            case 18: {
                n = 8;
                break;
            }
            default: {
                n = 9;
            }
        }
        return n;
    }
}

