/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Hashtable;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.impl.OfferUtil;
import org.jacorb.trading.impl.Recipe;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.DuplicatePolicyName;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.IllegalOfferId;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.InvalidLookupRef;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.MissingMandatoryProperty;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.PropertyTypeMismatch;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ProxyPOA;
import org.omg.CosTrading.ProxyPackage.IllegalRecipe;
import org.omg.CosTrading.ProxyPackage.NotProxyOfferId;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.ReadonlyDynamicProperty;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.UnknownOfferId;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class ProxyImpl
extends ProxyPOA {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private OfferDatabase m_db;
    private ServiceTypeRepository m_repos;

    private ProxyImpl() {
    }

    public ProxyImpl(TraderComp traderComp, SupportAttrib supportAttrib, OfferDatabase offerDatabase) {
        this.m_traderComp = traderComp;
        this.m_support = supportAttrib;
        this.m_db = offerDatabase;
        Object object = supportAttrib.getTypeRepos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(object);
    }

    @Override
    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    @Override
    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    @Override
    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    @Override
    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    @Override
    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    @Override
    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    @Override
    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    @Override
    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    @Override
    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String export_proxy(Lookup lookup, String string, Property[] propertyArray, boolean bl, String string2, Policy[] policyArray) throws IllegalServiceType, UnknownServiceType, InvalidLookupRef, IllegalPropertyName, PropertyTypeMismatch, ReadonlyDynamicProperty, MissingMandatoryProperty, IllegalRecipe, DuplicatePropertyName, DuplicatePolicyName {
        String string3 = null;
        if (lookup == null) {
            throw new InvalidLookupRef(lookup);
        }
        TypeStruct typeStruct = this.m_repos.fully_describe_type(string);
        if (typeStruct.masked) {
            throw new UnknownServiceType(string);
        }
        OfferUtil.validateProperties(this.m_db, propertyArray, string, typeStruct);
        if (!Recipe.validate(string2, propertyArray)) {
            throw new IllegalRecipe(string2);
        }
        Hashtable<String, Policy> hashtable = new Hashtable<String, Policy>();
        for (int i = 0; i < policyArray.length; ++i) {
            if (hashtable.containsKey(policyArray[i].name)) {
                throw new DuplicatePolicyName(policyArray[i].name);
            }
            hashtable.put(policyArray[i].name, policyArray[i]);
        }
        this.m_db.begin(1);
        try {
            string3 = this.m_db.createProxy(lookup, string, propertyArray, bl, string2, policyArray);
        }
        finally {
            this.m_db.end();
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withdraw_proxy(String string) throws IllegalOfferId, UnknownOfferId, NotProxyOfferId {
        if (!this.m_db.validateOfferId(string)) {
            throw new IllegalOfferId(string);
        }
        this.m_db.begin(1);
        try {
            if (!this.m_db.exists(string)) {
                throw new UnknownOfferId(string);
            }
            if (!this.m_db.isProxy(string)) {
                throw new NotProxyOfferId(string);
            }
            this.m_db.removeProxy(string);
        }
        finally {
            this.m_db.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyInfo describe_proxy(String string) throws IllegalOfferId, UnknownOfferId, NotProxyOfferId {
        ProxyInfo proxyInfo;
        if (!this.m_db.validateOfferId(string)) {
            throw new IllegalOfferId(string);
        }
        this.m_db.begin(0);
        try {
            if (!this.m_db.exists(string)) {
                throw new UnknownOfferId(string);
            }
            if (!this.m_db.isProxy(string)) {
                throw new NotProxyOfferId(string);
            }
            proxyInfo = this.m_db.describeProxy(string);
        }
        finally {
            this.m_db.end();
        }
        return proxyInfo;
    }
}

