/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.trading.db.TypeDatabase;
import org.jacorb.trading.db.simple.types.Incarnation;
import org.jacorb.trading.db.simple.types.Type;
import org.jacorb.trading.util.RWLock;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.IncarnationNumber;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class TypeDatabaseImpl
implements TypeDatabase {
    private Incarnation m_incarnation;
    private Hashtable m_types;
    private RWLock m_lock;
    private File m_dbFile;
    private boolean m_dirty = false;
    private static final String DB_FILE = "types.dat";

    private TypeDatabaseImpl() {
    }

    public TypeDatabaseImpl(String string) {
        this.m_dbFile = new File(string, DB_FILE);
        if (this.m_dbFile.exists()) {
            this.readObjects();
        } else {
            this.m_incarnation = new Incarnation();
            this.m_types = new Hashtable();
            this.writeObjects();
        }
        this.m_lock = new RWLock();
    }

    @Override
    public void begin(int n) {
        if (n == 0) {
            this.m_lock.acquireRead();
        } else if (n == 1) {
            this.m_lock.acquireWrite();
        } else {
            throw new RuntimeException("Invalid lock mode");
        }
    }

    @Override
    public void end() {
        if (this.m_dirty) {
            this.writeObjects();
            this.m_dirty = false;
        }
        this.m_lock.release();
    }

    @Override
    public synchronized TypeStruct describeType(String string) {
        TypeStruct typeStruct = null;
        Type type = (Type)this.m_types.get(string);
        if (type != null) {
            typeStruct = type.describe();
        }
        return typeStruct;
    }

    @Override
    public synchronized boolean maskType(String string) {
        boolean bl = false;
        Type type = (Type)this.m_types.get(string);
        if (type != null) {
            type.mask();
            this.m_dirty = true;
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized boolean unmaskType(String string) {
        boolean bl = false;
        Type type = (Type)this.m_types.get(string);
        if (type != null) {
            type.unmask();
            this.m_dirty = true;
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized String[] getTypes() {
        String[] stringArray = new String[this.m_types.size()];
        Enumeration enumeration = this.m_types.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    @Override
    public synchronized String[] getTypesSince(IncarnationNumber incarnationNumber) {
        Vector<String> vector = new Vector<String>();
        Incarnation incarnation = new Incarnation(incarnationNumber);
        Enumeration enumeration = this.m_types.elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            if (type.getIncarnation().compareTo(incarnation) < 0) continue;
            vector.addElement(type.getName());
        }
        String[] stringArray = new String[vector.size()];
        vector.copyInto(stringArray);
        return stringArray;
    }

    @Override
    public IncarnationNumber getIncarnation() {
        return this.m_incarnation.getIncarnationNumber();
    }

    @Override
    public synchronized IncarnationNumber createType(String string, String string2, PropStruct[] propStructArray, String[] stringArray) {
        IncarnationNumber incarnationNumber = null;
        incarnationNumber = this.m_incarnation.getIncarnationNumber();
        Type type = new Type(string, string2, propStructArray, stringArray, incarnationNumber);
        this.m_types.put(string, type);
        this.m_incarnation.increment();
        this.m_dirty = true;
        return incarnationNumber;
    }

    @Override
    public synchronized boolean removeType(String string) {
        boolean bl = false;
        if (this.m_types.containsKey(string)) {
            this.m_types.remove(string);
            this.m_dirty = true;
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized String findSubType(String string) {
        String string2 = null;
        Enumeration enumeration = this.m_types.elements();
        block0: while (enumeration.hasMoreElements() && string2 == null) {
            Type type = (Type)enumeration.nextElement();
            String[] stringArray = type.getSuperTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                string2 = type.getName();
                continue block0;
            }
        }
        return string2;
    }

    @Override
    public synchronized String[] getAllSuperTypes(String string) {
        String[] stringArray = null;
        Type type = (Type)this.m_types.get(string);
        if (type != null) {
            Vector vector = this.findAllSuperTypes(type);
            stringArray = new String[vector.size()];
            vector.copyInto(stringArray);
        }
        return stringArray;
    }

    protected synchronized void readObjects() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.m_dbFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.m_incarnation = (Incarnation)objectInputStream.readObject();
            this.m_types = (Hashtable)objectInputStream.readObject();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.getMessage());
        }
    }

    protected synchronized void writeObjects() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.m_dbFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.m_incarnation);
            objectOutputStream.writeObject(this.m_types);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    protected synchronized Vector findAllSuperTypes(Type type) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = type.getSuperTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
            Type type2 = (Type)this.m_types.get(stringArray[i]);
            Vector vector2 = this.findAllSuperTypes(type2);
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }
}

