/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jacorb.trading.TradingService;
import org.jacorb.trading.db.simple.offers.TypeCodeValue;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;

public class AnyValue
implements Serializable {
    private TypeCodeValue m_type;
    private java.lang.Object m_value;
    static final long serialVersionUID = 3945922728443512828L;
    private transient DynAnyFactory factory;
    private transient ORB orb;
    private transient boolean initialized = false;

    private AnyValue() {
    }

    public AnyValue(ORB oRB, Any any) {
        this.init(oRB);
        this.setValue(any);
    }

    public void init(ORB oRB) {
        this.orb = oRB;
        try {
            this.factory = DynAnyFactoryHelper.narrow(oRB.resolve_initial_references("DynAnyFactory"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initialized = true;
    }

    public static boolean isTypeSupported(TypeCode typeCode) {
        boolean bl = false;
        try {
            TypeCode typeCode2 = typeCode;
            while (typeCode2.kind() == TCKind.tk_alias) {
                typeCode2 = typeCode2.content_type();
            }
            TCKind tCKind = typeCode2.kind();
            if (tCKind == TCKind.tk_null || tCKind == TCKind.tk_void) {
                bl = true;
            } else {
                if (tCKind == TCKind.tk_sequence) {
                    TypeCode typeCode3 = typeCode2.content_type();
                    tCKind = typeCode3.kind();
                }
                switch (tCKind.value()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 18: {
                        bl = true;
                    }
                }
            }
        }
        catch (BadKind badKind) {
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            // empty catch block
        }
        return bl;
    }

    public Any getValue() {
        if (!this.initialized) {
            throw new RuntimeException("AnyVale not initialized!");
        }
        Any any = null;
        TypeCode typeCode = this.m_type.getValue();
        boolean bl = false;
        try {
            java.lang.Object[] objectArray;
            TypeCode typeCode2 = typeCode;
            while (typeCode2.kind() == TCKind.tk_alias) {
                typeCode2 = typeCode2.content_type();
            }
            TCKind tCKind = typeCode2.kind();
            if (tCKind == TCKind.tk_sequence) {
                objectArray = typeCode2.content_type();
                tCKind = objectArray.kind();
                bl = true;
            }
            switch (tCKind.value()) {
                case 0: 
                case 1: {
                    any = this.orb.create_any();
                    any.type(typeCode);
                    break;
                }
                case 2: {
                    if (bl) {
                        objectArray = (short[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_short((short)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Short)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_short(objectArray.shortValue());
                    any = dynAny.to_any();
                    break;
                }
                case 3: {
                    if (bl) {
                        objectArray = (int[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_long((int)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Integer)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_long(objectArray.intValue());
                    any = dynAny.to_any();
                    break;
                }
                case 4: {
                    if (bl) {
                        objectArray = (short[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_ushort((short)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Short)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_ushort(objectArray.shortValue());
                    any = dynAny.to_any();
                    break;
                }
                case 5: {
                    if (bl) {
                        objectArray = (int[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_ulong((int)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Integer)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_ulong(objectArray.intValue());
                    any = dynAny.to_any();
                    break;
                }
                case 6: {
                    if (bl) {
                        objectArray = (float[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_float((float)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Float)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_float(objectArray.floatValue());
                    any = dynAny.to_any();
                    break;
                }
                case 7: {
                    if (bl) {
                        objectArray = (double[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_double((double)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Double)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_double(objectArray.doubleValue());
                    any = dynAny.to_any();
                    break;
                }
                case 8: {
                    if (bl) {
                        objectArray = (boolean[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_boolean((boolean)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Boolean)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_boolean(objectArray.booleanValue());
                    any = dynAny.to_any();
                    break;
                }
                case 9: {
                    if (bl) {
                        objectArray = (char[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_char((char)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Character)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_char(objectArray.charValue());
                    any = dynAny.to_any();
                    break;
                }
                case 18: {
                    if (bl) {
                        objectArray = (String[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_string((String)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (String)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_string((String)objectArray);
                    any = dynAny.to_any();
                    break;
                }
                case 10: {
                    if (bl) {
                        objectArray = (byte[])this.m_value;
                        DynSequence dynSequence = (DynSequence)this.factory.create_dyn_any_from_type_code(typeCode);
                        dynSequence.set_length(objectArray.length);
                        dynSequence.rewind();
                        for (int i = 0; i < objectArray.length; ++i) {
                            dynSequence.current_component().insert_octet((byte)objectArray[i]);
                            dynSequence.next();
                        }
                        any = dynSequence.to_any();
                        break;
                    }
                    objectArray = (Byte)this.m_value;
                    DynAny dynAny = this.factory.create_dyn_any_from_type_code(typeCode);
                    dynAny.insert_octet(objectArray.byteValue());
                    any = dynAny.to_any();
                }
            }
        }
        catch (BadKind badKind) {
            throw new RuntimeException(badKind.getMessage());
        }
        catch (InvalidValue invalidValue) {
            throw new RuntimeException(invalidValue.getMessage());
        }
        catch (TypeMismatch typeMismatch) {
            throw new RuntimeException(typeMismatch.getMessage());
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            throw new RuntimeException(inconsistentTypeCode.getMessage());
        }
        return any;
    }

    protected void setValue(Any any) {
        if (!this.initialized) {
            throw new RuntimeException("AnyVale not initialized!");
        }
        TypeCode typeCode = any.type();
        this.m_type = new TypeCodeValue(typeCode);
        boolean bl = false;
        try {
            IDLEntity iDLEntity;
            TypeCode typeCode2 = typeCode;
            while (typeCode2.kind() == TCKind.tk_alias) {
                typeCode2 = typeCode2.content_type();
            }
            TCKind tCKind = typeCode2.kind();
            if (tCKind == TCKind.tk_sequence) {
                iDLEntity = typeCode2.content_type();
                tCKind = ((TypeCode)iDLEntity).kind();
                bl = true;
            }
            iDLEntity = this.factory.create_dyn_any(any);
            switch (tCKind.value()) {
                case 0: {
                    this.m_value = null;
                    break;
                }
                case 1: {
                    this.m_value = null;
                    break;
                }
                case 2: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        short[] sArray = new short[n];
                        for (int i = 0; i < n; ++i) {
                            sArray[i] = dynSequence.current_component().get_short();
                            dynSequence.next();
                        }
                        this.m_value = sArray;
                        break;
                    }
                    this.m_value = new Short(iDLEntity.get_short());
                    break;
                }
                case 3: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        int[] nArray = new int[n];
                        for (int i = 0; i < n; ++i) {
                            nArray[i] = dynSequence.current_component().get_long();
                            dynSequence.next();
                        }
                        this.m_value = nArray;
                        break;
                    }
                    this.m_value = new Integer(iDLEntity.get_long());
                    break;
                }
                case 4: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        short[] sArray = new short[n];
                        for (int i = 0; i < n; ++i) {
                            sArray[i] = dynSequence.current_component().get_ushort();
                            dynSequence.next();
                        }
                        this.m_value = sArray;
                        break;
                    }
                    this.m_value = new Short(iDLEntity.get_ushort());
                    break;
                }
                case 5: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        int[] nArray = new int[n];
                        for (int i = 0; i < n; ++i) {
                            nArray[i] = dynSequence.current_component().get_ulong();
                            dynSequence.next();
                        }
                        this.m_value = nArray;
                        break;
                    }
                    this.m_value = new Integer(iDLEntity.get_ulong());
                    break;
                }
                case 6: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        float[] fArray = new float[n];
                        for (int i = 0; i < n; ++i) {
                            fArray[i] = dynSequence.current_component().get_float();
                            dynSequence.next();
                        }
                        this.m_value = fArray;
                        break;
                    }
                    this.m_value = new Float(iDLEntity.get_float());
                    break;
                }
                case 7: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        double[] dArray = new double[n];
                        for (int i = 0; i < n; ++i) {
                            dArray[i] = dynSequence.current_component().get_double();
                            dynSequence.next();
                        }
                        this.m_value = dArray;
                        break;
                    }
                    this.m_value = new Double(iDLEntity.get_double());
                    break;
                }
                case 8: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        boolean[] blArray = new boolean[n];
                        for (int i = 0; i < n; ++i) {
                            blArray[i] = dynSequence.current_component().get_boolean();
                            dynSequence.next();
                        }
                        this.m_value = blArray;
                        break;
                    }
                    this.m_value = new Boolean(iDLEntity.get_boolean());
                    break;
                }
                case 9: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        char[] cArray = new char[n];
                        for (int i = 0; i < n; ++i) {
                            cArray[i] = dynSequence.current_component().get_char();
                            dynSequence.next();
                        }
                        this.m_value = cArray;
                        break;
                    }
                    this.m_value = new Character(iDLEntity.get_char());
                    break;
                }
                case 18: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        String[] stringArray = new String[n];
                        for (int i = 0; i < n; ++i) {
                            stringArray[i] = dynSequence.current_component().get_string();
                            dynSequence.next();
                        }
                        this.m_value = stringArray;
                        break;
                    }
                    this.m_value = iDLEntity.get_string();
                    break;
                }
                case 10: {
                    if (bl) {
                        DynSequence dynSequence = DynSequenceHelper.narrow((Object)((java.lang.Object)iDLEntity));
                        int n = dynSequence.get_length();
                        byte[] byArray = new byte[n];
                        for (int i = 0; i < n; ++i) {
                            byArray[i] = dynSequence.current_component().get_octet();
                            dynSequence.next();
                        }
                        this.m_value = byArray;
                        break;
                    }
                    this.m_value = new Byte(iDLEntity.get_octet());
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type");
                }
            }
            iDLEntity.destroy();
        }
        catch (BadKind badKind) {
            throw new RuntimeException(badKind.getMessage());
        }
        catch (TypeMismatch typeMismatch) {
            throw new RuntimeException(typeMismatch.getMessage());
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            throw new RuntimeException(inconsistentTypeCode.getMessage());
        }
        catch (InvalidValue invalidValue) {
            throw new RuntimeException(invalidValue.getMessage());
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            throw new RuntimeException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(TradingService.getORB());
    }
}

