/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class ULongValue
implements Value {
    private Long m_value;

    public ULongValue() {
        this(0L);
    }

    public ULongValue(long l) {
        this.m_value = new Long(l);
    }

    public ULongValue(Object object) {
        this.m_value = (Long)object;
    }

    @Override
    public void setValue(Object object) {
        this.m_value = (Long)object;
    }

    @Override
    public int getTypeId() {
        return 4;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    @Override
    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)value.getValue();
        bl = this.m_value < l;
        return bl;
    }

    @Override
    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    @Override
    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    @Override
    public boolean greaterThanEqual(Value value) {
        return !this.lessThan(value);
    }

    @Override
    public Value plus(Value value) {
        ULongValue uLongValue = null;
        if (value.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)value.getValue();
        uLongValue = new ULongValue(this.m_value + l);
        return uLongValue;
    }

    @Override
    public Value minus(Value value) {
        Value value2 = null;
        if (value.getTypeId() == 4) {
            Long l = (Long)value.getValue();
            long l2 = this.m_value - l;
            value2 = l2 < 0L ? ValueFactory.createLong((int)l2) : new ULongValue(l2);
        } else {
            throw new IllegalArgumentException();
        }
        return value2;
    }

    @Override
    public Value multiply(Value value) {
        Value value2 = null;
        if (value.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)value.getValue();
        value2 = ValueFactory.createULong(this.m_value * l);
        return value2;
    }

    @Override
    public Value divide(Value value) {
        ULongValue uLongValue = null;
        if (value.getTypeId() != 4) {
            throw new IllegalArgumentException();
        }
        Long l = (Long)value.getValue();
        uLongValue = new ULongValue(this.m_value / l);
        return uLongValue;
    }

    @Override
    public Value negate() {
        return ValueFactory.createLong(-1 * this.m_value.intValue());
    }

    @Override
    public Value convert(int n) {
        Value value = null;
        switch (n) {
            case 3: {
                value = ValueFactory.createLong(this.m_value.intValue());
                break;
            }
            case 4: {
                value = new ULongValue(this.m_value);
                break;
            }
            case 5: {
                value = ValueFactory.createFloat(this.m_value.floatValue());
                break;
            }
            case 6: {
                value = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    @Override
    public String toString() {
        return this.m_value.toString();
    }
}

