/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;

public class StringValue
implements Value {
    private String m_value;

    public StringValue() {
        this(null);
    }

    public StringValue(String string) {
        this.m_value = string;
    }

    public StringValue(Object object) {
        this.m_value = (String)object;
    }

    @Override
    public void setValue(Object object) {
        this.m_value = (String)object;
    }

    @Override
    public int getTypeId() {
        return 8;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 8) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    @Override
    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 8) {
            throw new IllegalArgumentException();
        }
        String string = (String)value.getValue();
        bl = this.m_value.compareTo(string) < 0;
        return bl;
    }

    @Override
    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    @Override
    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    @Override
    public boolean greaterThanEqual(Value value) {
        return !this.lessThan(value);
    }

    @Override
    public Value plus(Value value) {
        throw new ArithmeticException();
    }

    @Override
    public Value minus(Value value) {
        throw new ArithmeticException();
    }

    @Override
    public Value multiply(Value value) {
        throw new ArithmeticException();
    }

    @Override
    public Value divide(Value value) {
        throw new ArithmeticException();
    }

    @Override
    public Value negate() {
        throw new ArithmeticException();
    }

    @Override
    public Value convert(int n) {
        StringValue stringValue = null;
        if (n != 8) {
            throw new IllegalArgumentException();
        }
        stringValue = new StringValue(this.m_value);
        return stringValue;
    }

    @Override
    public String toString() {
        return this.m_value;
    }
}

