/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class ShortValue
implements Value {
    private Integer m_value;

    public ShortValue() {
        this(0);
    }

    public ShortValue(int n) {
        this.m_value = new Integer(n);
    }

    public ShortValue(Object object) {
        this.m_value = (Integer)object;
    }

    @Override
    public void setValue(Object object) {
        this.m_value = (Integer)object;
    }

    @Override
    public int getTypeId() {
        return 1;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 1) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    @Override
    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 1) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        bl = this.m_value < n;
        return bl;
    }

    @Override
    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    @Override
    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    @Override
    public boolean greaterThanEqual(Value value) {
        return !this.lessThan(value);
    }

    @Override
    public Value plus(Value value) {
        ShortValue shortValue = null;
        if (value.getTypeId() != 1) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        shortValue = new ShortValue(this.m_value + n);
        return shortValue;
    }

    @Override
    public Value minus(Value value) {
        ShortValue shortValue = null;
        if (value.getTypeId() != 1) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        shortValue = new ShortValue(this.m_value - n);
        return shortValue;
    }

    @Override
    public Value multiply(Value value) {
        ShortValue shortValue = null;
        if (value.getTypeId() != 1) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        shortValue = new ShortValue(this.m_value * n);
        return shortValue;
    }

    @Override
    public Value divide(Value value) {
        ShortValue shortValue = null;
        if (value.getTypeId() != 1) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        shortValue = new ShortValue(this.m_value / n);
        return shortValue;
    }

    @Override
    public Value negate() {
        ShortValue shortValue = null;
        shortValue = new ShortValue(-1 * this.m_value);
        return shortValue;
    }

    @Override
    public Value convert(int n) {
        Value value = null;
        switch (n) {
            case 1: {
                value = new ShortValue(this.m_value);
                break;
            }
            case 2: {
                value = ValueFactory.createUShort(this.m_value);
                break;
            }
            case 3: {
                value = ValueFactory.createLong(this.m_value);
                break;
            }
            case 4: {
                value = ValueFactory.createULong(this.m_value.longValue());
                break;
            }
            case 5: {
                value = ValueFactory.createFloat(this.m_value.floatValue());
                break;
            }
            case 6: {
                value = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    @Override
    public String toString() {
        return this.m_value.toString();
    }
}

