/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class LongValue
implements Value {
    private Integer m_value;

    public LongValue() {
        this(0);
    }

    public LongValue(int n) {
        this.m_value = new Integer(n);
    }

    public LongValue(Object object) {
        this.m_value = (Integer)object;
    }

    @Override
    public void setValue(Object object) {
        this.m_value = (Integer)object;
    }

    @Override
    public int getTypeId() {
        return 3;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    @Override
    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        bl = this.m_value < n;
        return bl;
    }

    @Override
    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    @Override
    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    @Override
    public boolean greaterThanEqual(Value value) {
        return !this.lessThan(value);
    }

    @Override
    public Value plus(Value value) {
        LongValue longValue = null;
        if (value.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        longValue = new LongValue(this.m_value + n);
        return longValue;
    }

    @Override
    public Value minus(Value value) {
        LongValue longValue = null;
        if (value.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        longValue = new LongValue(this.m_value - n);
        return longValue;
    }

    @Override
    public Value multiply(Value value) {
        LongValue longValue = null;
        if (value.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        longValue = new LongValue(this.m_value * n);
        return longValue;
    }

    @Override
    public Value divide(Value value) {
        LongValue longValue = null;
        if (value.getTypeId() != 3) {
            throw new IllegalArgumentException();
        }
        Integer n = (Integer)value.getValue();
        longValue = new LongValue(this.m_value / n);
        return longValue;
    }

    @Override
    public Value negate() {
        LongValue longValue = null;
        longValue = new LongValue(-1 * this.m_value);
        return longValue;
    }

    @Override
    public Value convert(int n) {
        Value value = null;
        switch (n) {
            case 3: {
                value = new LongValue(this.m_value);
                break;
            }
            case 4: {
                value = ValueFactory.createULong(this.m_value.longValue());
                break;
            }
            case 5: {
                value = ValueFactory.createFloat(this.m_value.floatValue());
                break;
            }
            case 6: {
                value = ValueFactory.createDouble(this.m_value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    @Override
    public String toString() {
        return this.m_value.toString();
    }
}

