/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;

public class CharValue
implements Value {
    private Character m_value;

    public CharValue() {
        this('\u0000');
    }

    public CharValue(char c) {
        this.m_value = new Character(c);
    }

    public CharValue(Object object) {
        this.m_value = (Character)object;
    }

    @Override
    public void setValue(Object object) {
        this.m_value = (Character)object;
    }

    @Override
    public int getTypeId() {
        return 7;
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 7) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    @Override
    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 7) {
            throw new IllegalArgumentException();
        }
        Character c = (Character)value.getValue();
        bl = this.m_value.charValue() < c.charValue();
        return bl;
    }

    @Override
    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    @Override
    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    @Override
    public boolean greaterThanEqual(Value value) {
        return !this.lessThan(value);
    }

    @Override
    public Value plus(Value value) {
        throw new ArithmeticException();
    }

    @Override
    public Value minus(Value value) {
        throw new ArithmeticException();
    }

    @Override
    public Value multiply(Value value) {
        throw new ArithmeticException();
    }

    @Override
    public Value divide(Value value) {
        throw new ArithmeticException();
    }

    @Override
    public Value negate() {
        throw new ArithmeticException();
    }

    @Override
    public Value convert(int n) {
        Value value = null;
        if (n == 7) {
            value = new CharValue(this.m_value);
        } else if (n == 8) {
            char[] cArray = new char[]{this.m_value.charValue()};
            String string = new String(cArray);
            value = ValueFactory.createString(string);
        } else {
            throw new IllegalArgumentException();
        }
        return value;
    }

    @Override
    public String toString() {
        return this.m_value.toString();
    }
}

