/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.typemgr;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jacorb.trading.client.typemgr.AddTypeDialog;
import org.jacorb.trading.client.util.ConfirmDialog;
import org.jacorb.trading.client.util.Constrain;
import org.jacorb.trading.client.util.QuickSort;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.AlreadyMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.HasSubTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.NotMasked;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class TypeManager
extends Frame
implements ActionListener,
ItemListener,
Runnable {
    private List m_types;
    private TextArea m_description;
    private Button m_add;
    private Button m_remove;
    private Checkbox m_masked;
    private Label m_incarnation;
    private Label m_status;
    private AddTypeDialog m_addDialog;
    private ServiceTypeRepository m_repos;
    private static ORB s_orb;

    public TypeManager(ServiceTypeRepository serviceTypeRepository) {
        super("Service Type Repository");
        this.setFont(new Font("Helvetica", 0, 12));
        this.m_repos = serviceTypeRepository;
        this.createContents();
        this.refreshTypes();
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new GridBagLayout());
        Constrain.constrain(panel2, new Label("Service types", 0), 0, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_types = new List();
        this.m_types.setMultipleMode(false);
        this.m_types.setSize(this.m_types.getMinimumSize(10));
        this.m_types.addItemListener(this);
        Constrain.constrain(panel2, this.m_types, 0, 1, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        Constrain.constrain(panel, panel2, 0, 0, 1, 1, 1, 18, 0.25, 1.0, 5, 10, 5, 5);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridBagLayout());
        Constrain.constrain(panel3, new Label("Description", 0), 0, 0, 2, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_description = new TextArea(10, 40);
        this.m_description.setEditable(false);
        Constrain.constrain(panel3, this.m_description, 0, 1, 2, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        Constrain.constrain(panel, panel3, 1, 0, 1, 1, 1, 12, 0.75, 1.0, 5, 5, 5, 10);
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(1, 2, 10, 0));
        this.m_add = new Button("Add...");
        this.m_add.setActionCommand("add");
        this.m_add.addActionListener(this);
        panel4.add(this.m_add);
        this.m_remove = new Button("Remove...");
        this.m_remove.setActionCommand("remove");
        this.m_remove.addActionListener(this);
        panel4.add(this.m_remove);
        Constrain.constrain(panel, panel4, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 5, 10, 5, 5);
        Panel panel5 = new Panel();
        panel5.setLayout(new GridBagLayout());
        this.m_masked = new Checkbox(" Masked");
        this.m_masked.addItemListener(this);
        Constrain.constrain(panel5, this.m_masked, 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
        this.m_incarnation = new Label("Incarnation:", 2);
        Constrain.constrain(panel5, this.m_incarnation, 1, 2, 1, 1, 2, 12, 1.0, 0.0, 0, 0, 0, 0);
        Constrain.constrain(panel, panel5, 1, 1, 1, 1, 2, 12, 1.0, 0.0, 5, 5, 5, 10);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 2, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 3, 10);
        this.add(panel);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.m_types) {
            this.updateButtons();
            this.clearStatus();
            if (itemEvent.getStateChange() == 1) {
                this.describeType();
            }
        } else if (itemEvent.getItemSelectable() == this.m_masked) {
            this.maskType(itemEvent.getStateChange() == 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("add")) {
            if (this.m_addDialog == null) {
                this.m_addDialog = new AddTypeDialog((Frame)this, this.m_repos);
                this.m_addDialog.setActionCommand("refresh");
                this.m_addDialog.addActionListener(this);
            }
            this.clearStatus();
            this.m_addDialog.setVisible(true);
        } else if (string.equals("remove")) {
            String string2 = this.m_types.getSelectedItem();
            ConfirmDialog confirmDialog = new ConfirmDialog((Frame)this, "Remove type '" + string2 + "'?");
            confirmDialog.setActionCommand("confirm");
            confirmDialog.addActionListener(this);
            this.clearStatus();
            confirmDialog.setVisible(true);
        } else if (string.equals("refresh")) {
            this.refreshTypes();
        } else if (string.equals("confirm")) {
            this.removeType();
        }
    }

    protected void removeType() {
        try {
            String string = this.m_types.getSelectedItem();
            this.m_repos.remove_type(string);
            this.m_types.remove(string);
            this.m_description.setText("");
            this.clearStatus();
            this.updateButtons();
        }
        catch (HasSubTypes hasSubTypes) {
            this.showStatus("Service type '" + hasSubTypes.the_type + "' has subtypes");
        }
        catch (IllegalServiceType illegalServiceType) {
            this.showStatus("Illegal service type: " + illegalServiceType.type);
        }
        catch (UnknownServiceType unknownServiceType) {
            this.showStatus("Unknown service type: " + unknownServiceType.type);
        }
    }

    protected void maskType(boolean bl) {
        try {
            String string = this.m_types.getSelectedItem();
            if (bl) {
                this.m_repos.mask_type(string);
            } else {
                this.m_repos.unmask_type(string);
            }
            this.clearStatus();
        }
        catch (NotMasked notMasked) {
            this.showStatus("Service type '" + notMasked.name + "' is not masked");
            this.m_masked.setState(false);
        }
        catch (AlreadyMasked alreadyMasked) {
            this.showStatus("Service type '" + alreadyMasked.name + "' is already masked");
            this.m_masked.setState(true);
        }
        catch (IllegalServiceType illegalServiceType) {
            this.showStatus("Illegal service type: " + illegalServiceType.type);
        }
        catch (UnknownServiceType unknownServiceType) {
            this.showStatus("Unknown service type: " + unknownServiceType.type);
        }
    }

    protected void refreshTypes() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        this.showStatus("Refreshing service types...");
        SpecifiedServiceTypes specifiedServiceTypes = new SpecifiedServiceTypes();
        specifiedServiceTypes.__default();
        String[] stringArray = this.m_repos.list_types(specifiedServiceTypes);
        QuickSort.sort(stringArray);
        this.m_types.removeAll();
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_types.add(stringArray[i]);
        }
        this.updateButtons();
        this.m_description.setText("");
        this.clearStatus();
    }

    protected void updateButtons() {
        if (this.m_types.getSelectedIndex() < 0) {
            this.m_remove.setEnabled(false);
            this.m_masked.setEnabled(false);
            this.m_incarnation.setText("Incarnation:");
            this.m_incarnation.setEnabled(false);
        } else {
            this.m_remove.setEnabled(true);
            this.m_masked.setEnabled(true);
            this.m_incarnation.setEnabled(true);
        }
    }

    protected void describeType() {
        try {
            String string = this.m_types.getSelectedItem();
            TypeStruct typeStruct = this.m_repos.describe_type(string);
            String string2 = this.printType(string, typeStruct);
            this.m_description.setText(string2);
            this.m_masked.setState(typeStruct.masked);
            this.m_incarnation.setText("Incarnation: {" + typeStruct.incarnation.high + ", " + typeStruct.incarnation.low + "}");
        }
        catch (IllegalServiceType illegalServiceType) {
            this.showStatus("Illegal service type: " + illegalServiceType.type);
        }
        catch (UnknownServiceType unknownServiceType) {
            this.showStatus("Unknown service type: " + unknownServiceType.type);
        }
        catch (SystemException systemException) {
            this.showStatus("System error occurred");
            systemException.printStackTrace();
        }
    }

    protected String printType(String string, TypeStruct typeStruct) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("service " + string + " ");
        if (typeStruct.super_types.length > 0) {
            stringBuffer.append(": ");
            for (n = 0; n < typeStruct.super_types.length; ++n) {
                stringBuffer.append(typeStruct.super_types[n]);
                if (n < typeStruct.super_types.length - 1) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append("{\n");
        stringBuffer.append("  interface " + typeStruct.if_name + ";\n");
        for (n = 0; n < typeStruct.props.length; ++n) {
            stringBuffer.append("  ");
            switch (typeStruct.props[n].mode.value()) {
                case 0: {
                    stringBuffer.append("property ");
                    break;
                }
                case 1: {
                    stringBuffer.append("readonly property ");
                    break;
                }
                case 2: {
                    stringBuffer.append("mandatory property ");
                    break;
                }
                case 3: {
                    stringBuffer.append("mandatory readonly property ");
                }
            }
            stringBuffer.append(this.convertType(typeStruct.props[n].value_type) + " " + typeStruct.props[n].name + ";\n");
        }
        stringBuffer.append("};\n");
        return stringBuffer.toString();
    }

    protected String convertType(TypeCode typeCode) {
        String string = null;
        TCKind tCKind = typeCode.kind();
        if (tCKind == TCKind.tk_sequence) {
            try {
                TypeCode typeCode2 = typeCode.content_type();
                tCKind = typeCode2.kind();
                string = "sequence<" + this.convertKind(tCKind) + ">";
            }
            catch (BadKind badKind) {
                throw new RuntimeException();
            }
        } else {
            string = this.convertKind(tCKind);
        }
        return string;
    }

    protected String convertKind(TCKind tCKind) {
        String string = "unknown";
        switch (tCKind.value()) {
            case 0: {
                string = "other";
                break;
            }
            case 8: {
                string = "boolean";
                break;
            }
            case 2: {
                string = "short";
                break;
            }
            case 4: {
                string = "unsigned short";
                break;
            }
            case 3: {
                string = "long";
                break;
            }
            case 5: {
                string = "unsigned long";
                break;
            }
            case 6: {
                string = "float";
                break;
            }
            case 7: {
                string = "double";
                break;
            }
            case 9: {
                string = "char";
                break;
            }
            case 18: {
                string = "string";
            }
        }
        return string;
    }

    protected void showStatus(String string) {
        this.m_status.setText(string);
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }

    protected static void usage() {
        System.out.println("Usage: TypeManager iorfile");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        java.lang.Object object;
        s_orb = ORB.init(stringArray, null);
        ServiceTypeRepository serviceTypeRepository = null;
        try {
            object = s_orb.resolve_initial_references("TradingService");
            if (object == null) {
                System.out.println("Invalid object");
                System.exit(1);
            }
            Lookup lookup = LookupHelper.narrow((Object)object);
            object = lookup.type_repos();
            serviceTypeRepository = ServiceTypeRepositoryHelper.narrow((Object)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        object = new TypeManager(serviceTypeRepository);
        ((Window)object).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
                System.exit(0);
            }
        });
        ((Window)object).pack();
        ((Window)object).setVisible(true);
    }
}

