/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.level2;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.security.level2.CredentialsImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.SecAttributeManager;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.Security.AttributeType;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.InvocationCredentialsType;
import org.omg.Security.OpaqueHolder;
import org.omg.Security.SecAttribute;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.CredentialsHolder;
import org.omg.SecurityLevel2.PrincipalAuthenticator;

public class SunJssePrincipalAuthenticatorImpl
extends LocalObject
implements PrincipalAuthenticator,
Configurable {
    private Logger logger;
    private String keyStoreLocation = null;
    private String storePassphrase = null;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration configuration2 = (org.jacorb.config.Configuration)configuration;
        this.logger = configuration2.getNamedLogger("jacorb.security.jsse");
        this.keyStoreLocation = configuration2.getAttribute("jacorb.security.keystore", null);
        String string = configuration2.getAttribute("jacorb.security.keystore_password", null);
    }

    @Override
    public int[] get_supported_authen_methods(String string) {
        return new int[]{0};
    }

    @Override
    public AuthenticationStatus authenticate(int n, String string, String string2, byte[] byArray, SecAttribute[] secAttributeArray, CredentialsHolder credentialsHolder, OpaqueHolder opaqueHolder, OpaqueHolder opaqueHolder2) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("starting authentication");
        }
        try {
            this.registerProvider();
            String string3 = string2;
            String string4 = new String(byArray);
            if (this.keyStoreLocation == null || this.storePassphrase == null || string3 == null || string4 == null) {
                return AuthenticationStatus.SecAuthFailure;
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(this.keyStoreLocation), this.storePassphrase.toCharArray());
            Certificate[] certificateArray = keyStore.getCertificateChain(string3);
            if (certificateArray == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("No keys found in keystore for alias \"" + string3 + "\"!");
                }
                return AuthenticationStatus.SecAuthFailure;
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(string3, string4.toCharArray());
            KeyAndCert keyAndCert = new KeyAndCert(privateKey, certificateArray);
            AttributeType attributeType = new AttributeType(new ExtensibleFamily(0, 1), 2);
            SecAttributeManager secAttributeManager = SecAttributeManager.getInstance();
            SecAttribute secAttribute = secAttributeManager.createAttribute(keyAndCert, attributeType);
            CredentialsImpl credentialsImpl = new CredentialsImpl(new SecAttribute[]{secAttribute}, AuthenticationStatus.SecAuthSuccess, InvocationCredentialsType.SecOwnCredentials);
            credentialsHolder.value = credentialsImpl;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("authentication succesfull");
            }
            return AuthenticationStatus.SecAuthSuccess;
        }
        catch (Exception exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exception: " + exception);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("authentication failed");
            }
            return AuthenticationStatus.SecAuthFailure;
        }
    }

    @Override
    public AuthenticationStatus continue_authentication(byte[] byArray, Credentials credentials, OpaqueHolder opaqueHolder, OpaqueHolder opaqueHolder2) {
        throw new NO_IMPLEMENT();
    }

    private void registerProvider() {
    }
}

