/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class SSLComponentInterceptor
extends LocalObject
implements IORInterceptor,
Configurable {
    private ORB orb = null;
    private TaggedComponent tc = null;
    private short supported = 0;
    private short required = 0;

    public SSLComponentInterceptor(ORB oRB) throws ConfigurationException {
        this.orb = oRB;
        this.configure(oRB.getConfiguration());
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.supported = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.required = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
    }

    @Override
    public String name() {
        return "SSLComponentCreator";
    }

    @Override
    public void destroy() {
    }

    @Override
    public void establish_components(IORInfo iORInfo) {
        try {
            if (this.tc == null) {
                SSL sSL = new SSL(this.supported, this.required, (short)this.orb.getBasicAdapter().getSSLPort());
                sSL.target_supports = (short)(sSL.target_supports | 0x80);
                sSL.target_supports = (short)(sSL.target_supports | 0x20);
                CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
                cDROutputStream.beginEncapsulatedArray();
                SSLHelper.write(cDROutputStream, sSL);
                this.tc = new TaggedComponent(20, cDROutputStream.getBufferCopy());
                cDROutputStream.close();
                cDROutputStream = null;
            }
            iORInfo.add_ior_component_to_profile(this.tc, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

