/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.portableInterceptor.RequestInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ServerInterceptorIterator
extends RequestInterceptorIterator {
    public static final short RECEIVE_REQUEST_SERVICE_CONTEXTS = 0;
    public static final short RECEIVE_REQUEST = 1;
    public static final short SEND_REPLY = 2;
    public static final short SEND_EXCEPTION = 3;
    public static final short SEND_OTHER = 4;
    private ServerRequestInfoImpl info = null;

    public ServerInterceptorIterator(Interceptor[] interceptorArray) {
        super(interceptorArray);
    }

    public void iterate(ServerRequestInfoImpl serverRequestInfoImpl, short s) throws UserException {
        this.info = serverRequestInfoImpl;
        this.op = s;
        serverRequestInfoImpl.update();
        serverRequestInfoImpl.caller_op = s;
        this.setDirection(s == 0 || s == 1);
        this.iterate();
        if (this.interceptor_ex != null) {
            if (this.interceptor_ex instanceof ForwardRequest) {
                throw (ForwardRequest)this.interceptor_ex;
            }
            throw (SystemException)this.interceptor_ex;
        }
    }

    @Override
    protected void invoke(Interceptor interceptor) throws UserException {
        try {
            switch (this.op) {
                case 0: {
                    ((ServerRequestInterceptor)interceptor).receive_request_service_contexts(this.info);
                    break;
                }
                case 1: {
                    ((ServerRequestInterceptor)interceptor).receive_request(this.info);
                    break;
                }
                case 2: {
                    ((ServerRequestInterceptor)interceptor).send_reply(this.info);
                    break;
                }
                case 3: {
                    ((ServerRequestInterceptor)interceptor).send_exception(this.info);
                    break;
                }
                case 4: {
                    ((ServerRequestInterceptor)interceptor).send_other(this.info);
                }
            }
        }
        catch (ForwardRequest forwardRequest) {
            this.reverseDirection();
            this.op = (short)4;
            this.info.reply_status = (short)3;
            this.info.forward_reference = forwardRequest.forward;
            this.interceptor_ex = forwardRequest;
        }
        catch (SystemException systemException) {
            this.reverseDirection();
            this.op = (short)3;
            this.interceptor_ex = systemException;
            SystemExceptionHelper.insert(this.info.sending_exception, systemException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.info.caller_op = this.op;
    }
}

