/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Hashtable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;

public abstract class RequestInfoImpl
extends LocalObject
implements RequestInfo {
    protected int request_id;
    protected String operation = null;
    protected Parameter[] arguments = null;
    protected TypeCode[] exceptions = null;
    protected Any result = null;
    protected boolean response_expected;
    protected Object forward_reference = null;
    protected short reply_status;
    protected Current current = null;
    protected Hashtable request_ctx = null;
    protected Hashtable reply_ctx = null;
    protected short caller_op = (short)-1;

    public RequestInfoImpl() {
        this.request_ctx = new Hashtable();
        this.reply_ctx = new Hashtable();
    }

    public void setRequestServiceContexts(ServiceContext[] serviceContextArray) {
        for (int i = 0; i < serviceContextArray.length; ++i) {
            this.request_ctx.put(new Integer(serviceContextArray[i].context_id), serviceContextArray[i]);
        }
    }

    public void setReplyServiceContexts(ServiceContext[] serviceContextArray) {
        for (int i = 0; i < serviceContextArray.length; ++i) {
            this.reply_ctx.put(new Integer(serviceContextArray[i].context_id), serviceContextArray[i]);
        }
    }

    public void setArguments(Parameter[] parameterArray) {
        this.arguments = parameterArray;
    }

    public void setResult(Any any) {
        this.result = any;
    }

    public Current current() {
        return this.current;
    }

    public void setCurrent(Current current) {
        this.current = current;
    }

    public void setReplyStatus(short s) {
        this.reply_status = s;
    }

    public void setForwardReference(Object object) {
        this.forward_reference = object;
    }

    @Override
    public Parameter[] arguments() {
        return this.arguments;
    }

    @Override
    public String[] contexts() {
        throw new NO_RESOURCES("JacORB does not support operation contexts", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public TypeCode[] exceptions() {
        return this.exceptions;
    }

    @Override
    public Object forward_reference() {
        return this.forward_reference;
    }

    @Override
    public ServiceContext get_reply_service_context(int n) {
        Integer n2 = new Integer(n);
        if (!this.reply_ctx.containsKey(n2)) {
            throw new BAD_PARAM("No ServiceContext with id " + n, 23, CompletionStatus.COMPLETED_MAYBE);
        }
        return (ServiceContext)this.reply_ctx.get(n2);
    }

    @Override
    public ServiceContext get_request_service_context(int n) {
        Integer n2 = new Integer(n);
        if (!this.request_ctx.containsKey(n2)) {
            throw new BAD_PARAM("No ServiceContext with id " + n, 23, CompletionStatus.COMPLETED_MAYBE);
        }
        return (ServiceContext)this.request_ctx.get(n2);
    }

    @Override
    public Any get_slot(int n) throws InvalidSlot {
        return this.current.get_slot(n);
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public String[] operation_context() {
        throw new NO_RESOURCES("JacORB does not support operation contexts", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public short reply_status() {
        return this.reply_status;
    }

    @Override
    public int request_id() {
        return this.request_id;
    }

    @Override
    public boolean response_expected() {
        return this.response_expected;
    }

    @Override
    public Any result() {
        if (this.result == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.result;
    }

    @Override
    public short sync_scope() {
        return 1;
    }
}

