/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.io.OutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;

class IIOPLoopbackOutputStream
extends OutputStream {
    private IIOPLoopbackInputStream lis;

    IIOPLoopbackOutputStream() {
    }

    IIOPLoopbackOutputStream(IIOPLoopbackInputStream iIOPLoopbackInputStream) throws IOException {
        iIOPLoopbackInputStream.connect(this);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkConnect();
        this.lis.writeIntoBuffer(byArray, n, n2);
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.checkConnect();
        this.lis.writeIntoBuffer(n);
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkConnect();
        this.lis.writerClose();
    }

    synchronized void connect(IIOPLoopbackInputStream iIOPLoopbackInputStream) throws IOException {
        this.lis = iIOPLoopbackInputStream;
    }

    private void checkConnect() throws IOException {
        if (this.lis == null) {
            throw new IOException("IIOPLoopbackOutputStream not connected");
        }
    }
}

