/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.portable.InputStream;

public class IIOPAddress
extends ProtocolAddressBase {
    private String source_name = null;
    private InetAddress host = null;
    private int port = -1;
    private boolean unresolvable = false;
    private boolean dnsEnabled = false;
    private boolean hideZoneID = true;
    private Logger logger;

    public IIOPAddress(String string, int n) {
        this.source_name = string;
        this.port = n < 0 ? n + 65536 : n;
    }

    public IIOPAddress() {
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.address");
        this.dnsEnabled = configuration.getAttribute("jacorb.dns.enable", "off").equals("on");
        this.hideZoneID = configuration.getAttribute("jacorb.ipv6.hide_zoneid", "on").equals("on");
    }

    private void init_host() {
        InetAddress inetAddress = null;
        boolean bl = false;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            try {
                inetAddress = InetAddress.getByName(null);
            }
            catch (UnknownHostException unknownHostException2) {
                // empty catch block
            }
        }
        if (this.source_name == null || this.source_name.length() == 0) {
            this.host = inetAddress;
        } else {
            int n;
            int n2 = this.source_name.indexOf(47);
            if (n2 > 0) {
                this.source_name = this.source_name.substring(0, n2);
            }
            if ((n = this.source_name.indexOf(37)) != -1) {
                bl = true;
            }
            if (!bl) {
                try {
                    this.host = InetAddress.getByName(this.source_name);
                }
                catch (UnknownHostException unknownHostException) {
                    if (this.logger != null && this.logger.isWarnEnabled()) {
                        this.logger.warn("init_host, " + this.source_name + " unresolvable");
                    }
                    this.unresolvable = true;
                    try {
                        this.host = InetAddress.getByName(null);
                    }
                    catch (UnknownHostException unknownHostException3) {}
                }
            } else {
                if (this.logger != null && this.logger.isWarnEnabled()) {
                    this.logger.warn("init_host, " + this.source_name + " is local-link address");
                }
                this.unresolvable = true;
                this.host = null;
            }
        }
    }

    public static IIOPAddress read(InputStream inputStream) {
        String string = inputStream.read_string();
        short s = inputStream.read_ushort();
        IIOPAddress iIOPAddress = new IIOPAddress(string, s);
        return iIOPAddress;
    }

    public String getIP() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.host.getHostAddress();
    }

    public String getHostname() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.dnsEnabled ? this.host.getCanonicalHostName() : this.host.getHostAddress();
    }

    public void setHostname(String string) {
        this.host = null;
        this.source_name = string;
    }

    public InetAddress getConfiguredHost() {
        if (this.source_name == null || this.source_name.length() == 0) {
            return null;
        }
        if (this.host == null) {
            this.init_host();
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public boolean equals(Object object) {
        if (object instanceof IIOPAddress) {
            IIOPAddress iIOPAddress = (IIOPAddress)object;
            if (this.port == iIOPAddress.port) {
                return this.source_name.equals(iIOPAddress.source_name);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.source_name != null) {
            return this.source_name.hashCode() + this.port;
        }
        if (this.host != null) {
            return this.host.hashCode() + this.port;
        }
        return this.port;
    }

    @Override
    public String toString() {
        return this.getHostname() + ":" + this.port;
    }

    @Override
    public boolean fromString(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return false;
        }
        this.source_name = null;
        int n2 = 0;
        this.source_name = n > 0 ? string.substring(0, n) : "";
        if (n < string.length() - 1) {
            n2 = Integer.parseInt(string.substring(n + 1));
        }
        this.init_host();
        this.port = n2 < 0 ? n2 + 65536 : n2;
        return true;
    }

    @Override
    public void write(CDROutputStream cDROutputStream) {
        int n;
        String string = this.getHostname();
        if (this.hideZoneID && (n = string.indexOf(37)) != -1) {
            string = string.substring(0, n);
        }
        cDROutputStream.write_string(string);
        cDROutputStream.write_ushort((short)this.port);
    }

    public static IIOPAddress read(CDRInputStream cDRInputStream) {
        String string = cDRInputStream.read_string();
        short s = cDRInputStream.read_ushort();
        return new IIOPAddress(string, s);
    }

    public String getOriginalHost() {
        if (this.source_name == null) {
            if (!this.dnsEnabled) {
                return this.getIP();
            }
            return this.getHostname() + " / " + this.getIP();
        }
        return this.source_name;
    }

    void replaceFrom(IIOPAddress iIOPAddress) {
        if (iIOPAddress.source_name != null) {
            this.setHostname(iIOPAddress.source_name);
        }
        if (iIOPAddress.port != -1) {
            this.setPort(iIOPAddress.port);
        }
    }
}

