/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.acs.AcsORBProfiler;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class ServerRequestListener
implements RequestListener,
Configurable {
    private ORB orb = null;
    private org.jacorb.poa.POA rootPOA = null;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private boolean require_ssl = false;

    public ServerRequestListener(org.omg.CORBA.ORB oRB, POA pOA) {
        this.orb = (ORB)oRB;
        this.rootPOA = (org.jacorb.poa.POA)pOA;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.giop.server.listener");
        boolean bl = this.configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        if (bl) {
            int n = this.configuration.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 16);
            this.require_ssl = bl && (n & 0x60) != 0;
        }
    }

    @Override
    public void requestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        Object object;
        RequestInputStream requestInputStream = new RequestInputStream(this.orb, byArray);
        if (this.require_ssl && !gIOPConnection.isSSL()) {
            block22: {
                ReplyOutputStream replyOutputStream = new ReplyOutputStream(requestInputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, requestInputStream.getGIOPMinor(), false, this.logger);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("About to reject request because connection is not SSL.");
                }
                SystemExceptionHelper.write(replyOutputStream, new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO));
                try {
                    gIOPConnection.sendReply(replyOutputStream);
                }
                catch (IOException iOException) {
                    if (!this.logger.isWarnEnabled()) break block22;
                    this.logger.warn("IOException", iOException);
                }
            }
            return;
        }
        if (Messages.responseExpected(requestInputStream.req_hdr.response_flags)) {
            gIOPConnection.incPendingMessages();
        }
        if (!gIOPConnection.isTCSNegotiated()) {
            if (requestInputStream.getGIOPMinor() == 0) {
                gIOPConnection.markTCSNegotiated();
            } else {
                object = CodeSet.getCodeSetContext(requestInputStream.req_hdr.service_context);
                if (object != null) {
                    gIOPConnection.setCodeSets(((CodeSetContext)object).char_data, ((CodeSetContext)object).wchar_data);
                    gIOPConnection.markTCSNegotiated();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received CodeSetContext. Using " + CodeSet.csName(((CodeSetContext)object).char_data) + " as TCS and " + CodeSet.csName(((CodeSetContext)object).wchar_data) + " as TCSW");
                    }
                }
            }
        }
        requestInputStream.setCodeSet(gIOPConnection.getTCS(), gIOPConnection.getTCSW());
        object = null;
        try {
            object = new ServerRequest(this.orb, requestInputStream, gIOPConnection);
        }
        catch (POAInternalError pOAInternalError) {
            block23: {
                if (this.configuration.getORB().getAcsORBProfiler() != null) {
                    try {
                        this.configuration.getORB().getAcsORBProfiler().undeliveredRequest(byArray.length, null, null, false);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Received a request with a non-jacorb object key");
                }
                if (requestInputStream.isLocateRequest()) {
                    LocateReplyOutputStream locateReplyOutputStream = new LocateReplyOutputStream(requestInputStream.req_hdr.request_id, 0, requestInputStream.getGIOPMinor());
                    try {
                        gIOPConnection.sendReply(locateReplyOutputStream);
                    }
                    catch (IOException iOException) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("IOException", iOException);
                        }
                        break block23;
                    }
                }
                ReplyOutputStream replyOutputStream = new ReplyOutputStream(requestInputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, requestInputStream.getGIOPMinor(), false, this.logger);
                SystemExceptionHelper.write(replyOutputStream, new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO));
                try {
                    gIOPConnection.sendReply(replyOutputStream);
                }
                catch (IOException iOException) {
                    if (!this.logger.isWarnEnabled()) break block23;
                    this.logger.warn("IOException", iOException);
                }
            }
            return;
        }
        this.deliverRequest((ServerRequest)object);
    }

    @Override
    public void locateRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        this.requestReceived(byArray, gIOPConnection);
    }

    @Override
    public void cancelRequestReceived(byte[] byArray, GIOPConnection gIOPConnection) {
    }

    private void deliverRequest(ServerRequest serverRequest) {
        block16: {
            org.jacorb.poa.POA pOA = this.rootPOA;
            try {
                int n;
                String[] stringArray;
                String string;
                List list = serverRequest.getScopes();
                for (int i = 0; i < list.size() && !(string = (String)list.get(i)).equals(""); ++i) {
                    try {
                        pOA = pOA._getChildPOA(string);
                        continue;
                    }
                    catch (ParentIsHolding parentIsHolding) {
                        stringArray = new String[list.size() - i];
                        for (n = 0; n < i; ++n) {
                            stringArray[n] = (String)list.get(n + i);
                        }
                        serverRequest.setRemainingPOAName(stringArray);
                        break;
                    }
                }
                try {
                    if (pOA == null) {
                        throw new INTERNAL("Request POA null!");
                    }
                    pOA._invoke(serverRequest);
                }
                catch (Throwable throwable) {
                    AcsORBProfiler acsORBProfiler = this.configuration.getORB().getAcsORBProfiler();
                    if (acsORBProfiler != null) {
                        stringArray = pOA == null ? null : pOA.the_name();
                        n = serverRequest.get_in().available();
                        try {
                            if (throwable instanceof TRANSIENT && throwable.getMessage().equals("resource limit reached")) {
                                acsORBProfiler.undeliveredRequest(n, (String)stringArray, serverRequest.operation(), true);
                            } else {
                                acsORBProfiler.undeliveredRequest(n, (String)stringArray, serverRequest.operation(), false);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
            }
            catch (WrongAdapter wrongAdapter) {
                serverRequest.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
                serverRequest.reply();
            }
            catch (SystemException systemException) {
                serverRequest.setSystemException(systemException);
                serverRequest.reply();
            }
            catch (Throwable throwable) {
                serverRequest.setSystemException(new UNKNOWN(throwable.toString()));
                serverRequest.reply();
                if (!this.logger.isWarnEnabled()) break block16;
                this.logger.warn("IOException", throwable);
            }
        }
    }
}

