/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.MessageReceptor;
import org.jacorb.util.threadpool.Consumer;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ThreadPool;

public class MessageReceptorPool {
    private static final int MAX_DEFAULT = 1000;
    private static MessageReceptorPool singleton = null;
    private int maxConnectionThreads = 1000;
    private ThreadPool pool = null;

    private MessageReceptorPool(Configuration configuration) {
        org.jacorb.config.Configuration configuration2 = (org.jacorb.config.Configuration)configuration;
        int n = 1000;
        n = configuration2.getAttributeAsInteger("jacorb.connection.max_threads", 1000);
        Logger logger = configuration2.getNamedLogger("jacorb.orb.giop");
        if (logger.isDebugEnabled()) {
            logger.debug("Maximum connection threads: " + n);
        }
        this.pool = new ThreadPool(new ConsumerFactory(){

            @Override
            public Consumer create() {
                return new MessageReceptor();
            }
        }, n, 5);
    }

    public static synchronized MessageReceptorPool getInstance(Configuration configuration) {
        if (singleton == null) {
            singleton = new MessageReceptorPool(configuration);
        }
        return singleton;
    }

    public void connectionCreated(GIOPConnection gIOPConnection) {
        this.pool.putJob(gIOPConnection);
    }
}

