/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.factory.PortRangeFactory;
import org.jacorb.orb.factory.SocketFactory;

public class PortRangeSocketFactory
extends PortRangeFactory
implements SocketFactory {
    public static final String MIN_PROP = "jacorb.net.socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.socket_factory.port.max";
    private Logger logger;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.port_range_fcty");
        this.portMin = this.getPortProperty(MIN_PROP);
        this.portMax = this.getPortProperty(MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                Socket socket = new Socket(string, n, inetAddress, i);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("PortRangeSocketFactory: Created server socket at :" + i);
                }
                return socket;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + string + ":" + n);
        }
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    @Override
    public boolean isSSL(Socket socket) {
        return false;
    }
}

