/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.factory.DefaultServerSocketFactory;
import org.jacorb.orb.factory.PortRangeFactory;
import org.jacorb.orb.factory.ServerSocketFactory;

public class PortRangeServerSocketFactory
extends PortRangeFactory
implements ServerSocketFactory {
    public static final String MIN_PROP = "jacorb.net.server_socket_factory.port.min";
    public static final String MAX_PROP = "jacorb.net.server_socket_factory.port.max";
    private Logger logger;
    private final ServerSocketFactory delegate;

    public PortRangeServerSocketFactory() {
        this(new DefaultServerSocketFactory());
    }

    public PortRangeServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.delegate = serverSocketFactory;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.port_rang_fctry");
        this.portMin = this.getPortProperty(MIN_PROP);
        this.portMax = this.getPortProperty(MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
    }

    @Override
    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        if (n <= this.portMax && n >= this.portMin) {
            try {
                return this.doCreateServerSocket(n, n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                return this.doCreateServerSocket(i, n2);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return this.handleCreationFailed();
    }

    private ServerSocket doCreateServerSocket(int n, int n2) throws IOException {
        ServerSocket serverSocket = this.delegate.createServerSocket(n, n2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PortRangeServerSocketFactory: Created server socket at :" + n);
        }
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        if (n <= this.portMax && n >= this.portMin) {
            try {
                return this.doCreateServerSocket(n, n2, inetAddress);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                return this.doCreateServerSocket(i, n2, inetAddress);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return this.handleCreationFailed();
    }

    private ServerSocket doCreateServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        ServerSocket serverSocket = this.delegate.createServerSocket(n, n2, inetAddress);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created server socket at :" + n);
        }
        return serverSocket;
    }

    @Override
    public ServerSocket createServerSocket(int n) throws BindException {
        if (n <= this.portMax && n >= this.portMin) {
            try {
                return this.doCreateServerSocket(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (int i = this.portMin; i <= this.portMax; ++i) {
            try {
                return this.doCreateServerSocket(i);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return this.handleCreationFailed();
    }

    private ServerSocket doCreateServerSocket(int n) throws IOException {
        ServerSocket serverSocket = this.delegate.createServerSocket(n);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created server socket at :" + n);
        }
        return serverSocket;
    }

    private ServerSocket handleCreationFailed() throws BindException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Cannot create server socket between ports " + this.portMin + " and " + this.portMax);
        }
        throw new BindException("PortRangeServerSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }
}

