/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;

public class TaggedComponentList
implements Cloneable {
    private TaggedComponent[] components = null;

    public TaggedComponentList(InputStream inputStream) {
        this.components = TaggedComponentSeqHelper.read(inputStream);
    }

    public TaggedComponentList(byte[] byArray) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
        cDRInputStream.openEncapsulatedArray();
        this.components = TaggedComponentSeqHelper.read(cDRInputStream);
    }

    public TaggedComponentList() {
        this.components = new TaggedComponent[0];
    }

    public int size() {
        return this.components.length;
    }

    public boolean isEmpty() {
        return this.components.length == 0;
    }

    public TaggedComponent get(int n) {
        return this.components[n];
    }

    public Object clone() throws CloneNotSupportedException {
        TaggedComponentList taggedComponentList = (TaggedComponentList)super.clone();
        taggedComponentList.components = new TaggedComponent[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            taggedComponentList.components[i] = new TaggedComponent(this.components[i].tag, new byte[this.components[i].component_data.length]);
            System.arraycopy(this.components[i].component_data, 0, taggedComponentList.components[i].component_data, 0, this.components[i].component_data.length);
        }
        return taggedComponentList;
    }

    public TaggedComponent[] asArray() {
        return this.components;
    }

    public void addComponent(int n, Object object, Class clazz) {
        try {
            Method method = clazz.getMethod("write", OutputStream.class, object.getClass());
            CDROutputStream cDROutputStream = new CDROutputStream();
            cDROutputStream.beginEncapsulatedArray();
            method.invoke(null, cDROutputStream, object);
            this.addComponent(n, cDROutputStream.getBufferCopy());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Helper " + clazz.getName() + " has no appropriate write() method.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Cannot access write() method of helper " + clazz.getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Exception while marshaling component data: " + invocationTargetException.getTargetException());
        }
    }

    public void addComponent(int n, byte[] byArray) {
        this.addComponent(new TaggedComponent(n, byArray));
    }

    public void addComponent(TaggedComponent taggedComponent) {
        TaggedComponent[] taggedComponentArray = new TaggedComponent[this.components.length + 1];
        System.arraycopy(this.components, 0, taggedComponentArray, 0, this.components.length);
        taggedComponentArray[this.components.length] = taggedComponent;
        this.components = taggedComponentArray;
    }

    public void addAll(TaggedComponentList taggedComponentList) {
        TaggedComponent[] taggedComponentArray = new TaggedComponent[this.components.length + taggedComponentList.components.length];
        System.arraycopy(this.components, 0, taggedComponentArray, 0, this.components.length);
        System.arraycopy(taggedComponentList.components, 0, taggedComponentArray, this.components.length, taggedComponentList.components.length);
        this.components = taggedComponentArray;
    }

    public Object getComponent(int n, Class clazz) {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag != n) continue;
            return this.getComponentData(this.components[i].component_data, clazz);
        }
        return null;
    }

    public String getStringComponent(int n) {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag != n) continue;
            CDRInputStream cDRInputStream = new CDRInputStream(null, this.components[i].component_data);
            cDRInputStream.openEncapsulatedArray();
            return cDRInputStream.read_string();
        }
        return null;
    }

    public List getComponents(int n, Class clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag != n) continue;
            arrayList.add(this.getComponentData(this.components[i].component_data, clazz));
        }
        return arrayList;
    }

    private Object getComponentData(byte[] byArray, Class clazz) {
        try {
            Method method = clazz.getMethod("read", InputStream.class);
            CDRInputStream cDRInputStream = new CDRInputStream(null, byArray);
            cDRInputStream.openEncapsulatedArray();
            return method.invoke(null, cDRInputStream);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Helper " + clazz.getName() + " has no appropriate read() method.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Cannot access read() method of helper " + clazz.getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Exception while reading component data: " + invocationTargetException.getTargetException());
        }
    }
}

