/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import org.jacorb.notification.util.DefaultWildcardMap;
import org.jacorb.notification.util.WildcardMap;

public class CachingWildcardMap
implements WildcardMap {
    private final Object[] cachedKeys_;
    private final Object[][] cachedValues_;
    private Object victimKey_;
    private Object[] victimValue_;
    private final int cacheSize_;
    private final WildcardMap delegate_;

    public CachingWildcardMap() {
        this(4, new DefaultWildcardMap());
    }

    public CachingWildcardMap(int n, WildcardMap wildcardMap) {
        this.cachedValues_ = new Object[n][];
        this.cachedKeys_ = new Object[n];
        this.cacheSize_ = n;
        this.delegate_ = wildcardMap;
    }

    private int calcPosition(String string) {
        return string.charAt(0) % this.cacheSize_;
    }

    private void invalidateCache() {
        for (int i = 0; i < this.cacheSize_; ++i) {
            this.cachedKeys_[i] = null;
        }
        this.victimKey_ = null;
    }

    @Override
    public void clear() {
        this.invalidateCache();
        this.delegate_.clear();
    }

    @Override
    public Object remove(Object object) {
        this.invalidateCache();
        return this.delegate_.remove(object);
    }

    @Override
    public Object put(Object object, Object object2) {
        this.invalidateCache();
        return this.delegate_.put(object, object2);
    }

    @Override
    public Object[] getWithExpansion(Object object) {
        Object[] objectArray;
        int n;
        String string = object.toString();
        if (string.equals(this.cachedKeys_[n = this.calcPosition(string)])) {
            objectArray = this.cachedValues_[n];
        } else if (string.equals(this.victimKey_)) {
            objectArray = this.victimValue_;
        } else {
            objectArray = this.delegate_.getWithExpansion(object);
            this.victimKey_ = this.cachedKeys_[n];
            this.victimValue_ = this.cachedValues_[n];
            this.cachedKeys_[n] = string;
            this.cachedValues_[n] = objectArray;
        }
        return objectArray;
    }

    @Override
    public Object getNoExpansion(Object object) {
        return this.delegate_.getNoExpansion(object);
    }
}

