/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.AbstractPoolable;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.notification.util.WeakHashSet;

public abstract class AbstractObjectPool
implements Runnable,
Configurable {
    public static final boolean DEBUG = false;
    public static final long SLEEP = 5000L;
    public static final int LOWER_WATERMARK_DEFAULT = 5;
    public static final int SIZE_INCREASE_DEFAULT = 3;
    public static final int INITIAL_SIZE_DEFAULT = 10;
    public static final int MAXIMUM_WATERMARK_DEFAULT = 20;
    public static final int MAXIMUM_SIZE_DEFAULT = 0;
    private static final List sPoolsToLookAfter = new ArrayList();
    private static AbstractObjectPool[] asArray;
    private static boolean modified;
    private static final AbstractObjectPool[] ARRAY_TEMPLATE;
    private static Thread sCleanerThread;
    private static final Logger sLogger_;
    private static ListCleaner sListCleaner;
    private static boolean sUseListCleaner;
    private final String name_;
    private final LinkedList pool_;
    private boolean isInitialized_;
    private final Set active_ = Collections.synchronizedSet(new WeakHashSet());
    private int lowerWatermark_;
    private int maxWatermark_;
    private int sizeIncrease_;
    private int initialSize_;
    private int maximumSize_;
    protected final Logger logger_ = LogUtil.getLogger(this.getClass().getName());
    protected Configuration config_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractObjectPool[] getAllPools() {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            if (modified) {
                asArray = sPoolsToLookAfter.toArray(ARRAY_TEMPLATE);
                modified = false;
            }
        }
        return asArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerPool(AbstractObjectPool abstractObjectPool) {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            sPoolsToLookAfter.add(abstractObjectPool);
            modified = true;
            AbstractObjectPool.startListCleaner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deregisterPool(AbstractObjectPool abstractObjectPool) {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            sPoolsToLookAfter.remove(abstractObjectPool);
            modified = true;
            if (sPoolsToLookAfter.isEmpty()) {
                AbstractObjectPool.getAllPools();
                AbstractObjectPool.stopListCleaner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ListCleaner getListCleaner() {
        Class<AbstractObjectPool> clazz = AbstractObjectPool.class;
        synchronized (AbstractObjectPool.class) {
            if (sListCleaner == null) {
                sListCleaner = new ListCleaner();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sListCleaner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopListCleaner() {
        Class<AbstractObjectPool> clazz = AbstractObjectPool.class;
        synchronized (AbstractObjectPool.class) {
            if (sCleanerThread != null) {
                sListCleaner.setInactive();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startListCleaner() {
        Class<AbstractObjectPool> clazz = AbstractObjectPool.class;
        synchronized (AbstractObjectPool.class) {
            if (sCleanerThread == null && sUseListCleaner) {
                sCleanerThread = new Thread(AbstractObjectPool.getListCleaner());
                sCleanerThread.setName("ObjectPoolCleaner");
                sCleanerThread.setPriority(2);
                sCleanerThread.setDaemon(true);
                sCleanerThread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void configure(Configuration configuration) {
        this.config_ = configuration;
        this.init();
    }

    protected AbstractObjectPool(String string) {
        this(string, 5, 3, 10, 20, 0);
    }

    protected AbstractObjectPool(String string, int n, int n2, int n3, int n4, int n5) {
        if (n5 > 0 && n3 > n5) {
            throw new IllegalArgumentException("InitialSize: " + n3 + " may not be larger than MaximumSize: " + n5);
        }
        this.name_ = string;
        this.pool_ = new LinkedList();
        this.lowerWatermark_ = n;
        this.sizeIncrease_ = n2;
        this.initialSize_ = n3;
        this.maxWatermark_ = n4;
        this.maximumSize_ = n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n;
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (this.pool_.size() > this.lowerWatermark_) {
                return;
            }
            n = this.getNumberOfCreationsAllowed();
        }
        int n2 = Math.min(this.sizeIncrease_, n);
        if (n2 > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n2);
            for (int i = 0; i < n2; ++i) {
                Object object = this.createInstance();
                arrayList.add(object);
            }
            LinkedList linkedList2 = this.pool_;
            synchronized (linkedList2) {
                this.pool_.addAll(arrayList);
            }
        }
    }

    private int getNumberOfCreationsAllowed() {
        int n = this.maximumSize_ > 0 ? this.maximumSize_ - this.active_.size() - this.pool_.size() : Integer.MAX_VALUE;
        return n;
    }

    private Object createInstance() {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("created newInstance " + this.getInfo());
        }
        return this.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        AbstractObjectPool.registerPool(this);
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (this.isInitialized_) {
                throw new IllegalStateException("Already Initialized");
            }
            for (int i = 0; i < this.initialSize_; ++i) {
                Object object = this.createInstance();
                this.pool_.add(object);
            }
            this.isInitialized_ = true;
        }
    }

    public void dispose() {
        AbstractObjectPool.deregisterPool(this);
        this.disposeCollection(this.pool_);
        this.pool_.clear();
        this.disposeCollection(this.active_);
        this.active_.clear();
    }

    private void disposeCollection(Collection collection) {
        for (Object e : collection) {
            try {
                Disposable disposable = (Disposable)e;
                try {
                    ((AbstractPoolable)e).setObjectPool(null);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                disposable.dispose();
            }
            catch (ClassCastException classCastException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lendObject() {
        this.checkIsInitialized();
        Object object = null;
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (!this.pool_.isEmpty()) {
                object = this.pool_.removeFirst();
            }
            if (object == null) {
                while (!this.isCreationAllowed()) {
                    this.poolIsEmpty();
                }
            }
        }
        if (object == null) {
            object = this.createInstance();
        }
        try {
            ((Configurable)object).configure(this.config_);
        }
        catch (ClassCastException classCastException) {
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException("Could not configure instance");
        }
        this.doActivateObject(object);
        this.active_.add(object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIsInitialized() {
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (!this.isInitialized_) {
                throw new IllegalStateException("Not initialized");
            }
        }
    }

    protected boolean isCreationAllowed() {
        return this.getNumberOfCreationsAllowed() > 0;
    }

    protected void poolIsEmpty() {
        throw new RuntimeException(this.getInfo() + ": No more Elements allowed. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        this.checkIsInitialized();
        if (this.active_.remove(object)) {
            this.doPassivateObject(object);
            if (this.pool_.size() < this.maxWatermark_) {
                LinkedList linkedList = this.pool_;
                synchronized (linkedList) {
                    this.pool_.add(object);
                    this.pool_.notifyAll();
                }
            } else {
                this.doDestroyObject(object);
            }
        } else {
            throw new IllegalArgumentException("Object " + object + " was not created by this pool");
        }
    }

    public String toString() {
        return this.getInfo();
    }

    private String getInfo() {
        return "[" + this.name_ + "] Active=" + this.active_.size() + " Pooled=" + this.pool_.size() + " MaximumSize=" + (this.maximumSize_ > 0 ? Integer.toString(this.maximumSize_) : "unlimited");
    }

    public abstract Object newInstance();

    public void doPassivateObject(Object object) {
    }

    public void doActivateObject(Object object) {
    }

    public void doDestroyObject(Object object) {
    }

    static {
        modified = true;
        ARRAY_TEMPLATE = new AbstractObjectPool[0];
        sLogger_ = LogUtil.getLogger(AbstractObjectPool.class.getName());
        sUseListCleaner = true;
    }

    private static class ListCleaner
    extends Thread {
        private AtomicBoolean active_ = new AtomicBoolean(true);

        private ListCleaner() {
        }

        public void setInactive() {
            this.active_.set(false);
            this.interrupt();
        }

        private void ensureIsActive() throws InterruptedException {
            if (!this.active_.get()) {
                throw new InterruptedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.active_.get()) {
                    try {
                        this.runLoop();
                    }
                    catch (InterruptedException interruptedException) {
                        sLogger_.info("PoolCleaner was interrupted");
                    }
                    catch (Exception exception) {
                        sLogger_.error("Error cleaning Pool", exception);
                    }
                }
            }
            finally {
                Class<AbstractObjectPool> clazz = AbstractObjectPool.class;
                synchronized (AbstractObjectPool.class) {
                    sCleanerThread = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
        }

        private void runLoop() throws InterruptedException {
            block4: while (true) {
                try {
                    ListCleaner.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.ensureIsActive();
                AbstractObjectPool[] abstractObjectPoolArray = AbstractObjectPool.getAllPools();
                int n = 0;
                while (true) {
                    if (n >= abstractObjectPoolArray.length) continue block4;
                    try {
                        abstractObjectPoolArray[n].run();
                    }
                    catch (Exception exception) {
                        sLogger_.error("Error cleaning up Pool", exception);
                    }
                    ++n;
                }
                break;
            }
        }
    }
}

