/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.MessageQueue;
import org.jacorb.notification.queue.MessageQueueAdapter;

public class DefaultMessageQueueAdapter
implements MessageQueueAdapter {
    private final MessageQueue queue_;
    private static final Message[] EMPTY = new Message[0];

    public DefaultMessageQueueAdapter(MessageQueue messageQueue) {
        this.queue_ = messageQueue;
    }

    @Override
    public void enqeue(Message message) {
        this.queue_.put(message);
    }

    @Override
    public boolean hasPendingMessages() {
        return !this.queue_.isEmpty();
    }

    @Override
    public int getPendingMessagesCount() {
        return this.queue_.getSize();
    }

    @Override
    public Message getMessageBlocking() throws InterruptedException {
        return this.queue_.getMessage(true);
    }

    @Override
    public Message getMessageNoBlock() throws InterruptedException {
        return this.queue_.getMessage(false);
    }

    @Override
    public Message[] getAllMessages() throws InterruptedException {
        return this.queue_.getAllMessages(false);
    }

    @Override
    public Message[] getUpToMessages(int n) throws InterruptedException {
        return this.queue_.getMessages(n, false);
    }

    @Override
    public Message[] getAtLeastMessages(int n) throws InterruptedException {
        if (this.queue_.getSize() >= n) {
            return this.queue_.getAllMessages(true);
        }
        return EMPTY;
    }

    @Override
    public void clear() {
        try {
            Message[] messageArray = this.queue_.getAllMessages(false);
            for (int i = 0; i < messageArray.length; ++i) {
                Message message = messageArray[i];
                message.dispose();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.queue_.toString();
    }

    @Override
    public String getDiscardPolicyName() {
        return this.queue_.getDiscardPolicyName();
    }

    @Override
    public String getOrderPolicyName() {
        return this.queue_.getOrderPolicyName();
    }

    @Override
    public void addDiscardListener(MessageQueue.DiscardListener discardListener) {
        this.queue_.addDiscardListener(discardListener);
    }

    @Override
    public void removeDiscardListener(MessageQueue.DiscardListener discardListener) {
        this.queue_.removeDiscardListener(discardListener);
    }
}

