/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedFifoEventQueue
extends AbstractBoundedEventQueue {
    private final LinkedList linkedList_ = new LinkedList();

    public BoundedFifoEventQueue(int n, EventQueueOverflowStrategy eventQueueOverflowStrategy) {
        this(n, eventQueueOverflowStrategy, new Object());
    }

    public BoundedFifoEventQueue(int n, EventQueueOverflowStrategy eventQueueOverflowStrategy, Object object) {
        super(n, eventQueueOverflowStrategy, object);
    }

    @Override
    public String getOrderPolicyName() {
        return "FifoOrder";
    }

    @Override
    public boolean isEmpty() {
        return this.linkedList_.isEmpty();
    }

    @Override
    public int getSize() {
        return this.linkedList_.size();
    }

    @Override
    protected Message getEarliestTimeout() {
        List list = (List)this.linkedList_.clone();
        Collections.sort(list, QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
        Message message = (Message)list.get(0);
        this.linkedList_.remove(message);
        return message;
    }

    @Override
    protected Message getLeastPriority() {
        List list = (List)this.linkedList_.clone();
        Collections.sort(list, QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
        Message message = (Message)list.get(0);
        this.linkedList_.remove(message);
        return message;
    }

    @Override
    protected Message getNextElement() {
        return this.getOldestElement();
    }

    @Override
    protected Message getOldestElement() {
        return (Message)this.linkedList_.removeFirst();
    }

    @Override
    protected Message getYoungestElement() {
        return (Message)this.linkedList_.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Message[] getAllElements() {
        try {
            Message[] messageArray = this.linkedList_.toArray(QueueUtil.MESSAGE_ARRAY_TEMPLATE);
            return messageArray;
        }
        finally {
            this.linkedList_.clear();
        }
    }

    @Override
    protected void addElement(Message message) {
        this.linkedList_.add(message);
    }

    @Override
    protected Message[] getElements(int n) {
        int n2 = n > this.linkedList_.size() ? this.linkedList_.size() : n;
        Message[] messageArray = new Message[n2];
        for (int i = 0; i < n2; ++i) {
            messageArray[i] = (Message)this.linkedList_.removeFirst();
        }
        return messageArray;
    }
}

