/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.MessageQueue;

public abstract class AbstractBoundedEventQueue
implements MessageQueue {
    private final Object lock_;
    private final int capacity_;
    private final List listeners_ = new ArrayList();
    private final EventQueueOverflowStrategy overflowStrategy_;

    protected AbstractBoundedEventQueue(int n, EventQueueOverflowStrategy eventQueueOverflowStrategy, Object object) {
        this.lock_ = object;
        this.capacity_ = n;
        this.overflowStrategy_ = eventQueueOverflowStrategy;
    }

    @Override
    public final String getDiscardPolicyName() {
        return this.overflowStrategy_.getDiscardPolicyName();
    }

    protected abstract Message getEarliestTimeout();

    protected abstract Message getLeastPriority();

    protected abstract Message getNextElement();

    protected abstract Message getOldestElement();

    protected abstract Message getYoungestElement();

    protected abstract Message[] getElements(int var1);

    protected abstract void addElement(Message var1);

    protected abstract Message[] getAllElements();

    @Override
    public abstract String getOrderPolicyName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] getAllMessages(boolean bl) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            if (bl) {
                return this.getAllBlocking();
            }
            return this.getAllElements();
        }
    }

    private Message[] getAllBlocking() throws InterruptedException {
        while (this.isEmpty()) {
            this.lock_.wait();
        }
        return this.getAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message getMessage(boolean bl) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            if (bl) {
                return this.getEventBlocking();
            }
            if (this.isEmpty()) {
                return null;
            }
            return this.getNextElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] getMessages(int n, boolean bl) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            if (bl) {
                return this.getEventsBlocking(n);
            }
            return this.getElements(n);
        }
    }

    private Message[] getEventsBlocking(int n) throws InterruptedException {
        while (this.isEmpty()) {
            this.lock_.wait();
        }
        return this.getElements(n);
    }

    private Message getEventBlocking() throws InterruptedException {
        while (this.isEmpty()) {
            this.lock_.wait();
        }
        return this.getNextElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Message message) {
        Object object = this.lock_;
        synchronized (object) {
            while (this.getSize() >= this.capacity_) {
                this.overflowStrategy_.removeElementFromQueue(this);
                this.fireMessageDiscarded();
            }
            this.addElement(message);
            this.lock_.notifyAll();
        }
    }

    private void fireMessageDiscarded() {
        Iterator iterator = this.listeners_.iterator();
        while (iterator.hasNext()) {
            ((MessageQueue.DiscardListener)iterator.next()).messageDiscarded(this.capacity_);
        }
    }

    @Override
    public void addDiscardListener(MessageQueue.DiscardListener discardListener) {
        this.listeners_.add(discardListener);
    }

    @Override
    public void removeDiscardListener(MessageQueue.DiscardListener discardListener) {
        this.listeners_.remove(discardListener);
    }
}

