/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.QueueUtil;

public abstract class AbstractBoundedEventHeap
extends AbstractBoundedEventQueue {
    private final PriorityQueue heap_;

    protected AbstractBoundedEventHeap(int n, EventQueueOverflowStrategy eventQueueOverflowStrategy, Object object, Comparator comparator) {
        super(n, eventQueueOverflowStrategy, object);
        this.heap_ = new PriorityQueue(n, comparator);
    }

    private final List copyAllEntries() {
        ArrayList arrayList = new ArrayList(this.heap_.size());
        arrayList.addAll(this.heap_);
        return arrayList;
    }

    private final List removeAllEntries() {
        List list = this.copyAllEntries();
        this.heap_.clear();
        return list;
    }

    protected final Message removeFirstElement(Comparator comparator) {
        List list = this.copyAllEntries();
        Collections.sort(list, comparator);
        Message message = (Message)list.remove(0);
        this.heap_.clear();
        this.heap_.addAll(list);
        return message;
    }

    @Override
    protected final Message[] getAllElements() {
        List list = this.removeAllEntries();
        return list.toArray(new Message[list.size()]);
    }

    @Override
    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public final int getSize() {
        return this.heap_.size();
    }

    @Override
    protected final void addElement(Message message) {
        this.heap_.add(message);
    }

    @Override
    protected final Message[] getElements(int n) {
        ArrayList arrayList = new ArrayList();
        while (this.heap_.peek() != null && arrayList.size() < n) {
            arrayList.add(this.heap_.remove());
        }
        return arrayList.toArray(QueueUtil.MESSAGE_ARRAY_TEMPLATE);
    }

    protected final Message getNextHeapElement() {
        return (Message)this.heap_.remove();
    }

    @Override
    protected final Message getNextElement() {
        return this.getNextHeapElement();
    }

    public final String toString() {
        return this.heap_.toString();
    }
}

