/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.lifecycle;

import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.lifecycle.IServantLifecyle;
import org.jacorb.notification.lifecycle.ManageableServant;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class ServantLifecyleControl
implements ManageableServant {
    private final IServantLifecyle delegate_;
    private final boolean runGCDuringDeactivation_;
    private Object thisRef_;
    private Servant thisServant_;

    public ServantLifecyleControl(IServantLifecyle iServantLifecyle, Configuration configuration) {
        this(iServantLifecyle, configuration.getAttribute("jacorb.notification.servant.deactivate.run_system_gc", "off").equalsIgnoreCase("on"));
    }

    public ServantLifecyleControl(IServantLifecyle iServantLifecyle, boolean bl) {
        this.delegate_ = iServantLifecyle;
        this.runGCDuringDeactivation_ = bl;
    }

    @Override
    public synchronized Object activate() {
        if (this.thisRef_ == null) {
            try {
                this.thisRef_ = this.delegate_.getPOA().servant_to_reference(this.getServant());
            }
            catch (ServantNotActive servantNotActive) {
                throw new RuntimeException();
            }
            catch (WrongPolicy wrongPolicy) {
                throw new RuntimeException();
            }
        }
        return this.thisRef_;
    }

    private Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = this.delegate_.newServant();
        }
        return this.thisServant_;
    }

    @Override
    public synchronized void deactivate() {
        if (this.thisServant_ != null) {
            POA pOA = this.delegate_.getPOA();
            try {
                byte[] byArray = pOA.servant_to_id(this.thisServant_);
                this.delegate_.getPOA().deactivate_object(byArray);
            }
            catch (WrongPolicy wrongPolicy) {
                throw new RuntimeException();
            }
            catch (ObjectNotActive objectNotActive) {
                throw new RuntimeException();
            }
            catch (ServantNotActive servantNotActive) {
                throw new RuntimeException();
            }
            finally {
                this.thisRef_ = null;
                this.thisServant_ = null;
                if (this.runGCDuringDeactivation_) {
                    System.runFinalization();
                    System.gc();
                }
            }
        }
    }
}

