/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.collections.AST;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.ETCLComponentName;
import org.jacorb.notification.filter.etcl.NumberValue;
import org.jacorb.notification.filter.etcl.TCLParserTokenTypes;
import org.jacorb.notification.filter.etcl.UnionPositionOperator;
import org.jacorb.notification.filter.etcl.VisitorException;

public class TCLCleanUp
extends AbstractTCLVisitor
implements TCLParserTokenTypes {
    public void fix(AbstractTCLNode abstractTCLNode) {
        try {
            abstractTCLNode.acceptPostOrder(this);
        }
        catch (VisitorException visitorException) {
            throw new RuntimeException(visitorException.getMessage());
        }
    }

    @Override
    public void visitComponent(ETCLComponentName eTCLComponentName) throws VisitorException {
        this.insertComponentName(eTCLComponentName);
    }

    @Override
    public void visitUnionPosition(UnionPositionOperator unionPositionOperator) throws VisitorException {
        this.fixUnionPosition(unionPositionOperator);
    }

    void insertComponentName(ETCLComponentName eTCLComponentName) {
        StringBuffer stringBuffer = new StringBuffer(eTCLComponentName.toString());
        for (AbstractTCLNode abstractTCLNode = eTCLComponentName.left(); abstractTCLNode != null; abstractTCLNode = (AbstractTCLNode)abstractTCLNode.getNextSibling()) {
            stringBuffer.append(abstractTCLNode.toString());
        }
        eTCLComponentName.setComponentName(stringBuffer.toString());
    }

    private void fixUnionPosition(UnionPositionOperator unionPositionOperator) {
        AST aST = unionPositionOperator.getNextSibling();
        if (aST == null) {
            unionPositionOperator.setDefault();
        } else {
            switch (aST.getType()) {
                case 21: {
                    Double d = ((NumberValue)aST).getNumber();
                    unionPositionOperator.setPosition(d);
                    unionPositionOperator.setNextSibling(aST.getNextSibling());
                }
                case 12: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    unionPositionOperator.setDefault();
                }
            }
        }
    }
}

