/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.UnaryOperator;
import org.jacorb.notification.filter.etcl.VisitorException;

public class MinusOperator
extends UnaryOperator {
    private boolean unary_;
    private static final String NAME = "MinusOperator";

    public MinusOperator(Token token) {
        super(token);
        this.setName(NAME);
    }

    @Override
    public void setType(int n) {
        this.unary_ = n == 18;
    }

    public String toString() {
        return " -";
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext evaluationContext, EvaluationResult evaluationResult) throws EvaluationException {
        if (this.unary_) {
            return EvaluationResult.unaryMinus(evaluationResult);
        }
        return EvaluationResult.minus(evaluationResult, this.right().evaluate(evaluationContext));
    }

    @Override
    public void acceptInOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        this.left().acceptInOrder(abstractTCLVisitor);
        abstractTCLVisitor.visitMinus(this);
        if (!this.unary_) {
            this.right().acceptInOrder(abstractTCLVisitor);
        }
    }

    @Override
    public void acceptPostOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        this.left().acceptPostOrder(abstractTCLVisitor);
        if (!this.unary_) {
            this.right().acceptPostOrder(abstractTCLVisitor);
        }
        abstractTCLVisitor.visitMinus(this);
    }

    @Override
    public void acceptPreOrder(AbstractTCLVisitor abstractTCLVisitor) throws VisitorException {
        abstractTCLVisitor.visitMinus(this);
        this.left().acceptPreOrder(abstractTCLVisitor);
        if (!this.unary_) {
            this.right().acceptPreOrder(abstractTCLVisitor);
        }
    }
}

