/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.filter.AbstractFilter;
import org.jacorb.notification.filter.MappingFilterUsageDecorator;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.GCDisposable;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidValue;
import org.omg.CosNotifyFilter.MappingConstraintInfo;
import org.omg.CosNotifyFilter.MappingConstraintPair;
import org.omg.CosNotifyFilter.MappingFilterOperations;
import org.omg.CosNotifyFilter.MappingFilterPOATie;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class MappingFilterImpl
implements GCDisposable,
MappingFilterOperations {
    private final AbstractFilter filterDelegate_;
    private final Any defaultValue_;
    private final ValueMap valueMap_ = new ValueMap();
    private final Logger logger_;
    private final MappingFilterPOATie servant_;
    private final MappingFilterUsageDecorator usageDecorator_;
    private final ORB orb_;
    private final DisposableManager disposeHooks_ = new DisposableManager();
    private final long maxIdleTime_;

    public MappingFilterImpl(ORB oRB, Configuration configuration, AbstractFilter abstractFilter, Any any) {
        this.orb_ = oRB;
        this.logger_ = LogUtil.getLogger(configuration, this.getClass().getName());
        this.filterDelegate_ = abstractFilter;
        this.defaultValue_ = any;
        this.usageDecorator_ = new MappingFilterUsageDecorator(this);
        this.servant_ = new MappingFilterPOATie(this.usageDecorator_.getMappingFilterOperations());
        this.maxIdleTime_ = configuration.getAttributeAsLong("jacorb.notification.filter.dead_interval", 0L);
    }

    public Object activate() {
        return this.servant_._this(this.orb_);
    }

    @Override
    public void destroy() {
        this.logger_.info("destroy MappingFilter");
        this.dispose();
    }

    public void dispose() {
        this.disposeHooks_.dispose();
        this.filterDelegate_.dispose();
        this.valueMap_.dispose();
    }

    @Override
    public String constraint_grammar() {
        return this.filterDelegate_.constraint_grammar();
    }

    @Override
    public TypeCode value_type() {
        return this.defaultValue_.type();
    }

    @Override
    public Any default_value() {
        return this.defaultValue_;
    }

    @Override
    public MappingConstraintInfo[] add_mapping_constraints(MappingConstraintPair[] mappingConstraintPairArray) throws InvalidValue, InvalidConstraint {
        ConstraintExp[] constraintExpArray = new ConstraintExp[mappingConstraintPairArray.length];
        for (int i = 0; i < mappingConstraintPairArray.length; ++i) {
            constraintExpArray[i] = mappingConstraintPairArray[i].constraint_expression;
        }
        ConstraintInfo[] constraintInfoArray = this.filterDelegate_.add_constraints(constraintExpArray);
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            mappingConstraintInfoArray[i] = new MappingConstraintInfo(constraintInfoArray[i].constraint_expression, constraintInfoArray[i].constraint_id, mappingConstraintPairArray[i].result_to_set);
            this.valueMap_.put(constraintInfoArray[i].constraint_id, mappingConstraintPairArray[i].result_to_set);
        }
        return mappingConstraintInfoArray;
    }

    @Override
    public void modify_mapping_constraints(int[] nArray, MappingConstraintInfo[] mappingConstraintInfoArray) throws ConstraintNotFound, InvalidValue, InvalidConstraint {
        int n;
        ConstraintInfo[] constraintInfoArray = new ConstraintInfo[mappingConstraintInfoArray.length];
        for (n = 0; n < constraintInfoArray.length; ++n) {
            constraintInfoArray[n] = new ConstraintInfo(mappingConstraintInfoArray[n].constraint_expression, mappingConstraintInfoArray[n].constraint_id);
            this.valueMap_.remove(mappingConstraintInfoArray[n].constraint_id);
        }
        this.filterDelegate_.modify_constraints(nArray, constraintInfoArray);
        for (n = 0; n < mappingConstraintInfoArray.length; ++n) {
            this.valueMap_.put(mappingConstraintInfoArray[n].constraint_id, mappingConstraintInfoArray[n].value);
        }
    }

    @Override
    public MappingConstraintInfo[] get_mapping_constraints(int[] nArray) throws ConstraintNotFound {
        ConstraintInfo[] constraintInfoArray = this.filterDelegate_.get_constraints(nArray);
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            mappingConstraintInfoArray[i] = new MappingConstraintInfo(constraintInfoArray[i].constraint_expression, constraintInfoArray[i].constraint_id, this.valueMap_.get(constraintInfoArray[i].constraint_id));
        }
        return mappingConstraintInfoArray;
    }

    @Override
    public MappingConstraintInfo[] get_all_mapping_constraints() {
        ConstraintInfo[] constraintInfoArray = this.filterDelegate_.get_all_constraints();
        MappingConstraintInfo[] mappingConstraintInfoArray = new MappingConstraintInfo[constraintInfoArray.length];
        for (int i = 0; i < constraintInfoArray.length; ++i) {
            mappingConstraintInfoArray[i] = new MappingConstraintInfo(constraintInfoArray[i].constraint_expression, constraintInfoArray[i].constraint_id, this.valueMap_.get(constraintInfoArray[i].constraint_id));
        }
        return mappingConstraintInfoArray;
    }

    @Override
    public void remove_all_mapping_constraints() {
        this.filterDelegate_.remove_all_constraints();
        this.valueMap_.dispose();
    }

    @Override
    public boolean match(Any any, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int n = this.filterDelegate_.match_internal(any);
        if (n >= 0) {
            anyHolder.value = this.valueMap_.get(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_structured(StructuredEvent structuredEvent, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int n = this.filterDelegate_.match_structured_internal(structuredEvent);
        if (n >= 0) {
            anyHolder.value = this.valueMap_.get(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_typed(Property[] propertyArray, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int n = this.filterDelegate_.match_typed_internal(propertyArray);
        if (n >= 0) {
            anyHolder.value = this.valueMap_.get(n);
            return true;
        }
        return false;
    }

    @Override
    public void attemptDispose() {
        AbstractFilter.attemptDispose(this, this.usageDecorator_.getLastUsage(), this.maxIdleTime_);
    }

    @Override
    public void registerDisposable(Disposable disposable) {
        this.disposeHooks_.addDisposable(disposable);
    }

    private static class ValueMap {
        private final Map valueMap_ = new Hashtable();

        private ValueMap() {
        }

        public void put(int n, Any any) {
            this.valueMap_.put(new Integer(n), any);
        }

        public Any get(int n) {
            return (Any)this.valueMap_.get(new Integer(n));
        }

        public Any remove(int n) {
            return (Any)this.valueMap_.remove(new Integer(n));
        }

        public void dispose() {
            this.valueMap_.clear();
        }
    }
}

