/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.util.Map;
import java.util.WeakHashMap;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.CurrentTimeUtil;
import org.jacorb.notification.filter.ETCLEvaluator;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.RuntimeVariable;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.ArrayOperator;
import org.jacorb.notification.filter.etcl.AssocOperator;
import org.jacorb.notification.filter.etcl.ETCLComponentName;
import org.jacorb.notification.filter.etcl.IdentValue;
import org.jacorb.notification.filter.etcl.ImplicitOperator;
import org.jacorb.notification.filter.etcl.ImplicitOperatorNode;
import org.jacorb.notification.filter.etcl.NumberValue;
import org.jacorb.notification.filter.etcl.UnionPositionOperator;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.util.AbstractPoolable;
import org.omg.CORBA.Any;
import org.omg.TimeBase.UtcT;

public class EvaluationContext
extends AbstractPoolable {
    private Message message_;
    private final ETCLEvaluator etclEvaluator_;
    private final Map resultCache_;
    private final Map anyCache_;
    private final CurrentTimeUtil currentTimeUtil_;

    public EvaluationContext(ETCLEvaluator eTCLEvaluator, CurrentTimeUtil currentTimeUtil) {
        this.etclEvaluator_ = eTCLEvaluator;
        this.currentTimeUtil_ = currentTimeUtil;
        this.resultCache_ = new WeakHashMap();
        this.anyCache_ = new WeakHashMap();
    }

    public EvaluationContext(ETCLEvaluator eTCLEvaluator) {
        this(eTCLEvaluator, CurrentTimeUtil.LOCAL_TIME);
    }

    @Override
    public void reset() {
        this.message_ = null;
        this.resultCache_.clear();
        this.anyCache_.clear();
    }

    public ETCLEvaluator getETCLEvaluator() {
        return this.etclEvaluator_;
    }

    public UtcT getCurrentTime() {
        return this.currentTimeUtil_.getCurrentTime();
    }

    public Message getCurrentMessage() {
        return this.message_;
    }

    public void setCurrentMessage(Message message) {
        this.message_ = message;
    }

    public void storeResult(String string, EvaluationResult evaluationResult) {
        this.resultCache_.put(string, evaluationResult);
    }

    public EvaluationResult lookupResult(String string) {
        return (EvaluationResult)this.resultCache_.get(string);
    }

    public void eraseResult(String string) {
        this.resultCache_.remove(string);
    }

    public void storeAny(String string, Any any) {
        this.anyCache_.put(string, any);
    }

    public Any lookupAny(String string) {
        return (Any)this.anyCache_.get(string);
    }

    public void eraseAny(String string) {
        this.anyCache_.remove(string);
    }

    public EvaluationResult extractFromMessage(EvaluationResult evaluationResult, ComponentName componentName, RuntimeVariable runtimeVariable) throws EvaluationException {
        ETCLComponentName eTCLComponentName = (ETCLComponentName)componentName;
        if (eTCLComponentName.right() != null) {
            return this.extractFromAny(eTCLComponentName.right(), evaluationResult.getAny(), runtimeVariable.toString());
        }
        return evaluationResult;
    }

    public EvaluationResult extractFromMessage(AbstractMessage abstractMessage, ComponentName componentName) throws EvaluationException {
        ETCLComponentName eTCLComponentName = (ETCLComponentName)componentName;
        return this.extractFromAny(eTCLComponentName.left(), abstractMessage.toAny(), eTCLComponentName.toString());
    }

    private EvaluationResult extractFromAny(AbstractTCLNode abstractTCLNode, Any any, String string) throws EvaluationException {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extractFromAny\n\trootname=" + string + "\n\tvalue=" + any);
        }
        EvaluationResult evaluationResult = null;
        Any any2 = null;
        Any any3 = any;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (AbstractTCLNode abstractTCLNode2 = abstractTCLNode; abstractTCLNode2 != null; abstractTCLNode2 = (AbstractTCLNode)abstractTCLNode2.getNextSibling()) {
            stringBuffer.append(abstractTCLNode2.toString());
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("current path=" + stringBuffer.toString());
                this.logger_.debug("current operator=" + abstractTCLNode2.toString());
                this.logger_.debug("current any=" + any3);
            }
            if ((any2 = this.lookupAny(stringBuffer.toString())) == null) {
                switch (abstractTCLNode2.getType()) {
                    case 6: {
                        break;
                    }
                    case 32: {
                        this.logger_.debug("evaluate union by position");
                        UnionPositionOperator unionPositionOperator = (UnionPositionOperator)abstractTCLNode2;
                        if (unionPositionOperator.isDefault()) {
                            any2 = this.getETCLEvaluator().evaluateUnion(any3);
                            break;
                        }
                        any2 = this.getETCLEvaluator().evaluateUnion(any3, unionPositionOperator.getPosition());
                        break;
                    }
                    case 11: {
                        String string2 = ((IdentValue)abstractTCLNode2).getIdentifier();
                        any2 = this.getETCLEvaluator().evaluateIdentifier(any3, string2);
                        break;
                    }
                    case 21: {
                        int n = ((NumberValue)abstractTCLNode2).getNumber().intValue();
                        any2 = this.getETCLEvaluator().evaluateIdentifier(any3, n);
                        break;
                    }
                    case 33: {
                        ImplicitOperator implicitOperator = ((ImplicitOperatorNode)abstractTCLNode2).getOperator();
                        any2 = implicitOperator.evaluateImplicit(this.getETCLEvaluator(), any3);
                        evaluationResult = EvaluationResult.fromAny(any2);
                        evaluationResult.addAny(any3);
                        return evaluationResult;
                    }
                    case 30: {
                        int n = ((ArrayOperator)abstractTCLNode2).getArrayIndex();
                        any2 = this.getETCLEvaluator().evaluateArrayIndex(any3, n);
                        break;
                    }
                    case 31: {
                        String string3 = ((AssocOperator)abstractTCLNode2).getAssocName();
                        any2 = this.getETCLEvaluator().evaluateNamedValueList(any3, string3);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected operator: " + AbstractTCLNode.getNameForType(abstractTCLNode2.getType()));
                    }
                }
            }
            if (any2 == null) continue;
            this.storeAny(stringBuffer.toString(), any2);
            any3 = any2;
        }
        evaluationResult = EvaluationResult.fromAny(any2);
        return evaluationResult;
    }
}

