/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.omg.CORBA.AnyHolder;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class FilterProxySupplierTask
extends AbstractFilterTask {
    public static final AlternateMessageMap EMPTY_MAP = new AlternateMessageMap(Collections.EMPTY_MAP){

        @Override
        public void clear() {
        }
    };
    final AlternateMessageMap changedMessages_ = new AlternateMessageMap();
    private static int sCount = 0;
    private int id_ = ++sCount;

    public FilterProxySupplierTask(TaskFactory taskFactory, TaskExecutor taskExecutor) {
        super(taskFactory, taskExecutor);
    }

    public String toString() {
        return "[FilterProxySupplierTask#" + this.id_ + "]";
    }

    @Override
    public void reset() {
        super.reset();
        this.changedMessages_.clear();
    }

    @Override
    public void doFilter() throws InterruptedException {
        this.filter();
        this.getTaskFactory().enqueueMessage(this);
    }

    private Message updatePriority(int n, Message message) {
        Message message2;
        block4: {
            AnyHolder anyHolder = new AnyHolder();
            message2 = message;
            try {
                boolean bl = message.match(this.arrayCurrentFilterStage_[n].getPriorityFilter(), anyHolder);
                if (bl) {
                    message2 = (Message)this.getMessage().clone();
                    message2.setPriority(anyHolder.value.extract_long());
                }
            }
            catch (UnsupportedFilterableData unsupportedFilterableData) {
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("unable to evaluate PriorityFilter", unsupportedFilterableData);
                }
                if (!this.logger_.isInfoEnabled()) break block4;
                this.logger_.info("unable to evaluate PriorityFilter");
            }
        }
        return message2;
    }

    private Message updateTimeout(int n, Message message) {
        Message message2;
        block4: {
            AnyHolder anyHolder = new AnyHolder();
            message2 = message;
            try {
                boolean bl = message2.match(this.arrayCurrentFilterStage_[n].getLifetimeFilter(), anyHolder);
                if (bl && message2 == this.getMessage()) {
                    message2 = (Message)this.getMessage().clone();
                    message2.setTimeout(anyHolder.value.extract_long());
                }
            }
            catch (UnsupportedFilterableData unsupportedFilterableData) {
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("unable to evaluate PriorityFilter", unsupportedFilterableData);
                }
                if (!this.logger_.isInfoEnabled()) break block4;
                this.logger_.info("unable to evaluate PriorityFilter");
            }
        }
        return message2;
    }

    private void filter() {
        for (int i = 0; i < this.arrayCurrentFilterStage_.length; ++i) {
            boolean bl = false;
            if (!this.arrayCurrentFilterStage_[i].isDestroyed()) {
                Message message = this.getMessage();
                if (this.arrayCurrentFilterStage_[i].hasPriorityFilter()) {
                    message = this.updatePriority(i, message);
                }
                if (this.arrayCurrentFilterStage_[i].hasLifetimeFilter()) {
                    message = this.updateTimeout(i, message);
                }
                if (message != this.getMessage()) {
                    this.changedMessages_.putAlternateMessage(this.arrayCurrentFilterStage_[i], message);
                }
                bl = message.match(this.arrayCurrentFilterStage_[i]);
            }
            if (!bl) continue;
            this.addFilterStage(this.arrayCurrentFilterStage_[i].getSubsequentFilterStages());
        }
    }

    static class AlternateMessageMap {
        private final Map alternateMessages_;

        public AlternateMessageMap() {
            this(new HashMap());
        }

        AlternateMessageMap(Map map) {
            this.alternateMessages_ = map;
        }

        public Message getAlternateMessage(FilterStage filterStage) {
            if (this.alternateMessages_.containsKey(filterStage)) {
                return (Message)this.alternateMessages_.get(filterStage);
            }
            return null;
        }

        public void putAlternateMessage(FilterStage filterStage, Message message) {
            this.alternateMessages_.put(filterStage, message);
        }

        public void clear() {
            this.alternateMessages_.clear();
        }
    }
}

