/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.container;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.IContainer;
import org.jacorb.notification.filter.DefaultFilterFactoryDelegate;
import org.jacorb.notification.filter.FilterFactoryImpl;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.notification.util.PatternWrapper;
import org.omg.CORBA.ORB;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractComponentAdapter;

class FilterFactoryComponentAdapter
extends AbstractComponentAdapter {
    private static final long serialVersionUID = 1L;
    private final Logger logger_ = LogUtil.getLogger(((Object)((Object)this)).getClass().getName());

    public FilterFactoryComponentAdapter() {
        super(FilterFactory.class, FilterFactory.class);
    }

    public void verify(PicoContainer picoContainer) {
    }

    public Object getComponentInstance(PicoContainer picoContainer) {
        if (!"builtin".equals(this.getFilterFactoryLocation(picoContainer))) {
            try {
                return this.lookupFilterFactory(picoContainer);
            }
            catch (Exception exception) {
                this.logger_.info("Could not resolve FilterFactory. Will fall back to builtin FilterFactory.", exception);
            }
        }
        return this.newFilterFactory(picoContainer);
    }

    private FilterFactory newFilterFactory(PicoContainer picoContainer) {
        PatternWrapper.class.getName();
        final MutablePicoContainer mutablePicoContainer = (MutablePicoContainer)picoContainer;
        final MutablePicoContainer mutablePicoContainer2 = mutablePicoContainer.makeChildContainer();
        mutablePicoContainer2.registerComponentImplementation(DefaultFilterFactoryDelegate.class);
        mutablePicoContainer2.registerComponentImplementation(FilterFactoryImpl.class);
        mutablePicoContainer2.registerComponentInstance(IContainer.class, (Object)new IContainer(){

            @Override
            public MutablePicoContainer getContainer() {
                return mutablePicoContainer2;
            }

            @Override
            public void destroy() {
                mutablePicoContainer.removeChildContainer((PicoContainer)mutablePicoContainer2);
            }
        });
        FilterFactoryImpl filterFactoryImpl = (FilterFactoryImpl)mutablePicoContainer2.getComponentInstanceOfType(FilterFactoryImpl.class);
        return FilterFactoryHelper.narrow(filterFactoryImpl.activate());
    }

    private FilterFactory lookupFilterFactory(PicoContainer picoContainer) {
        String string = this.getFilterFactoryLocation(picoContainer);
        ORB oRB = (ORB)picoContainer.getComponentInstance(ORB.class);
        return FilterFactoryHelper.narrow(oRB.string_to_object(string));
    }

    private String getFilterFactoryLocation(PicoContainer picoContainer) {
        Configuration configuration = (Configuration)picoContainer.getComponentInstance(Configuration.class);
        String string = configuration.getAttribute("jacorb.notification.default_filter_factory", "builtin");
        return string;
    }
}

