/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Date;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.filter.ComponentName;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.TCKind;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.StructuredEventHelper;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;

public class StructuredEventMessage
extends AbstractMessage {
    private Any anyValue_;
    private StructuredEvent structuredEventValue_;
    private Property[] typedEventValue_;
    private String constraintKey_;
    private Date startTime_ = null;
    private Date stopTime_ = null;
    private long timeout_ = 0L;
    private boolean isTimeoutSet_;
    private short priority_;
    private NoTranslationException translationException_ = null;

    public synchronized void setStructuredEvent(StructuredEvent structuredEvent, boolean bl, boolean bl2) {
        this.structuredEventValue_ = structuredEvent;
        this.constraintKey_ = AbstractMessage.calcConstraintKey(this.structuredEventValue_.header.fixed_header.event_type.domain_name, this.structuredEventValue_.header.fixed_header.event_type.type_name);
        this.parseQosSettings(bl, bl2);
    }

    @Override
    public void doReset() {
        this.anyValue_ = null;
        this.structuredEventValue_ = null;
        this.typedEventValue_ = null;
        this.constraintKey_ = null;
        this.startTime_ = null;
        this.stopTime_ = null;
        this.priority_ = 0;
        this.translationException_ = null;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public synchronized Any toAny() {
        if (this.anyValue_ == null) {
            this.anyValue_ = sOrb.create_any();
            StructuredEventHelper.insert(this.anyValue_, this.structuredEventValue_);
        }
        return this.anyValue_;
    }

    @Override
    public synchronized StructuredEvent toStructuredEvent() {
        return this.structuredEventValue_;
    }

    @Override
    public synchronized Property[] toTypedEvent() throws NoTranslationException {
        if (this.translationException_ != null) {
            throw this.translationException_;
        }
        if (this.typedEventValue_ == null) {
            try {
                if (!this.structuredEventValue_.filterable_data[0].name.equals("operation")) {
                    throw new IllegalArgumentException();
                }
                if (!this.structuredEventValue_.filterable_data[0].value.type().kind().equals(TCKind.tk_string)) {
                    throw new IllegalArgumentException();
                }
                this.typedEventValue_ = this.structuredEventValue_.filterable_data;
            }
            catch (Exception exception) {
                this.translationException_ = new NoTranslationException(exception);
                throw this.translationException_;
            }
        }
        return this.typedEventValue_;
    }

    @Override
    public synchronized String getConstraintKey() {
        return this.constraintKey_;
    }

    @Override
    public EvaluationResult extractFilterableData(EvaluationContext evaluationContext, ComponentName componentName, String string) throws EvaluationException {
        Any any = evaluationContext.getETCLEvaluator().evaluatePropertyList(this.toStructuredEvent().filterable_data, string);
        return EvaluationResult.fromAny(any);
    }

    @Override
    public EvaluationResult extractVariableHeader(EvaluationContext evaluationContext, ComponentName componentName, String string) throws EvaluationException {
        Any any = evaluationContext.getETCLEvaluator().evaluatePropertyList(this.toStructuredEvent().header.variable_header, string);
        return EvaluationResult.fromAny(any);
    }

    private synchronized void parseQosSettings(boolean bl, boolean bl2) {
        Property[] propertyArray = this.toStructuredEvent().header.variable_header;
        for (int i = 0; i < propertyArray.length; ++i) {
            if (bl && "StartTime".equals(propertyArray[i].name)) {
                this.startTime_ = new Date(StructuredEventMessage.unixTime(UtcTHelper.extract(propertyArray[i].value)));
                continue;
            }
            if (bl2 && "StopTime".equals(propertyArray[i].name)) {
                this.stopTime_ = new Date(StructuredEventMessage.unixTime(UtcTHelper.extract(propertyArray[i].value)));
                continue;
            }
            if (bl2 && "Timeout".equals(propertyArray[i].name)) {
                this.setTimeout(TimeTHelper.extract(propertyArray[i].value) / 10000L);
                continue;
            }
            if (!"Priority".equals(propertyArray[i].name)) continue;
            this.priority_ = propertyArray[i].value.extract_short();
        }
    }

    private static long unixTime(UtcT utcT) {
        long l = (utcT.time - 122192928000000000L) / 10000L;
        if (utcT.tdf != 0) {
            l -= (long)(utcT.tdf * 60000);
        }
        return l;
    }

    @Override
    public synchronized boolean hasStartTime() {
        return this.startTime_ != null;
    }

    @Override
    public synchronized long getStartTime() {
        return this.startTime_.getTime();
    }

    @Override
    public synchronized boolean hasStopTime() {
        return this.stopTime_ != null;
    }

    @Override
    public synchronized long getStopTime() {
        return this.stopTime_.getTime();
    }

    @Override
    public synchronized boolean hasTimeout() {
        return this.isTimeoutSet_;
    }

    @Override
    public synchronized long getTimeout() {
        return this.timeout_;
    }

    private synchronized void setTimeout(long l) {
        this.isTimeoutSet_ = true;
        this.timeout_ = l;
    }

    @Override
    public boolean match(Filter filter) throws UnsupportedFilterableData {
        return filter.match_structured(this.toStructuredEvent());
    }

    @Override
    public synchronized int getPriority() {
        return this.priority_;
    }

    @Override
    public boolean match(MappingFilter mappingFilter, AnyHolder anyHolder) throws UnsupportedFilterableData {
        return mappingFilter.match_structured(this.toStructuredEvent(), anyHolder);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StructuredEventMessage [referenced=");
        stringBuffer.append(this.referenced_);
        stringBuffer.append(", StructuredEvent=");
        stringBuffer.append(this.toStructuredEvent());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

