/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.util.LogUtil;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;

public class FilterManager
implements FilterAdminOperations {
    public static final FilterManager EMPTY_FILTER_MANAGER = new FilterManager(Collections.EMPTY_MAP);
    private static final Integer[] INTEGER_ARRAY_TEMPLATE = new Integer[0];
    private final Map filters_;
    private final Object filtersLock_ = new Object();
    private boolean filtersModified_;
    private final List filterList_ = new ArrayList();
    private final List filtersReadOnlyView_ = Collections.unmodifiableList(this.filterList_);
    private final AtomicInteger filterIdPool_ = new AtomicInteger(0);
    private final Logger logger_;

    protected FilterManager(Map map) {
        this.filters_ = map;
        this.filtersModified_ = true;
        this.logger_ = LogUtil.getLogger(this.getClass().getName());
    }

    public FilterManager() {
        this(new HashMap());
    }

    private Integer newFilterID() {
        return new Integer(this.filterIdPool_.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add_filter(Filter filter) {
        Integer n = this.newFilterID();
        if (this.logger_.isInfoEnabled()) {
            try {
                if (!((ObjectImpl)((Object)filter))._is_local()) {
                    this.logger_.info("filter is not local!");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.filtersLock_;
        synchronized (object) {
            this.filters_.put(n, filter);
            this.filtersModified_ = true;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove_filter(int n) throws FilterNotFound {
        Integer n2 = new Integer(n);
        Object object = this.filtersLock_;
        synchronized (object) {
            if (this.filters_.containsKey(n2)) {
                this.filters_.remove(n2);
                this.filtersModified_ = true;
            } else {
                this.throwFilterNotFound(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Filter get_filter(int n) throws FilterNotFound {
        Filter filter;
        Integer n2 = new Integer(n);
        Object object = this.filtersLock_;
        synchronized (object) {
            filter = (Filter)this.filters_.get(n2);
        }
        if (filter == null) {
            this.throwFilterNotFound(n2);
        }
        return filter;
    }

    private void throwFilterNotFound(Integer n) throws FilterNotFound {
        throw new FilterNotFound("Filter with ID=" + n + " does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] get_all_filters() {
        Integer[] integerArray;
        Object object = this.filtersLock_;
        synchronized (object) {
            integerArray = this.filters_.keySet().toArray(INTEGER_ARRAY_TEMPLATE);
        }
        object = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            object[i] = integerArray[i];
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove_all_filters() {
        Object object = this.filtersLock_;
        synchronized (object) {
            this.filters_.clear();
            this.filtersModified_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilters() {
        Object object = this.filtersLock_;
        synchronized (object) {
            if (this.filtersModified_) {
                this.filterList_.clear();
                this.filterList_.addAll(this.filters_.values());
                this.filtersModified_ = false;
            }
        }
        return this.filtersReadOnlyView_;
    }
}

