/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.filter.EventTypeIdentifier;
import org.omg.CosNotification.EventType;

public class EventTypeWrapper
implements EventTypeIdentifier,
Comparable {
    private final EventType eventType_;
    private final String constraintKey_;
    public static final EventType EVENT_TYPE_ALL = new EventType("", "%ALL");
    public static final EventType[] EMPTY_EVENT_TYPE_ARRAY = new EventType[0];

    public EventTypeWrapper(EventType eventType) {
        this.eventType_ = eventType;
        this.constraintKey_ = AbstractMessage.calcConstraintKey(eventType.domain_name, eventType.type_name);
    }

    public EventType getEventType() {
        return this.eventType_;
    }

    public String toString() {
        return EventTypeWrapper.toString(this.eventType_);
    }

    public boolean equals(Object object) {
        try {
            return EventTypeWrapper.equals(this.eventType_, ((EventTypeWrapper)object).eventType_);
        }
        catch (ClassCastException classCastException) {
            return super.equals(object);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(Object object) {
        try {
            EventTypeWrapper eventTypeWrapper = (EventTypeWrapper)object;
            int n = this.eventType_.domain_name.compareTo(eventTypeWrapper.eventType_.domain_name);
            if (n == 0) {
                n = this.eventType_.type_name.compareTo(eventTypeWrapper.eventType_.type_name);
            }
            return n;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException();
        }
    }

    public static String toString(EventType eventType) {
        StringBuffer stringBuffer = new StringBuffer();
        EventTypeWrapper.appendEventTypeToBuffer(eventType, stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendEventTypeToBuffer(EventType eventType, StringBuffer stringBuffer) {
        stringBuffer.append(eventType.domain_name);
        stringBuffer.append("/");
        stringBuffer.append(eventType.type_name);
    }

    public static String toString(EventType[] eventTypeArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < eventTypeArray.length; ++i) {
            EventTypeWrapper.appendEventTypeToBuffer(eventTypeArray[i], stringBuffer);
            if (i >= eventTypeArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static boolean equals(EventType eventType, EventType eventType2) {
        return eventType.domain_name.equals(eventType2.domain_name) && eventType.type_name.equals(eventType2.type_name);
    }

    @Override
    public String getConstraintKey() {
        return this.constraintKey_;
    }
}

