/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.ir.gui.typesystem.Interface;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.Value;
import org.jacorb.ir.gui.typesystem.remote.IRAttribute;
import org.jacorb.ir.gui.typesystem.remote.IRConstant;
import org.jacorb.ir.gui.typesystem.remote.IRContainer;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IRInterface;
import org.jacorb.ir.gui.typesystem.remote.IROperation;
import org.jacorb.ir.gui.typesystem.remote.IRTypedef;
import org.jacorb.ir.gui.typesystem.remote.IRValueMember;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.ValueDefHelper;

public class IRValue
extends IRContainer
implements Value {
    private Value baseValue = null;
    private boolean lookedUpBaseValue = false;
    private Value[] abstractBaseValues = null;
    private IRInterface[] interfaces = null;
    private IRAttribute[] allFields = null;
    private IROperation[] allOperations = null;
    private IRValueMember[] allMembers = null;

    public IRValue() {
    }

    public IRValue(IRObject iRObject) {
        super(iRObject);
    }

    @Override
    public String[] allowedToAdd() {
        String[] stringArray = new String[]{IRAttribute.nodeTypeName(), IROperation.nodeTypeName(), IRConstant.nodeTypeName(), IRTypedef.nodeTypeName(), IRException.nodeTypeName(), IRValueMember.nodeTypeName()};
        return stringArray;
    }

    @Override
    public String description() {
        Value[] valueArray;
        String string = super.description();
        Value value = this.getBaseValue();
        string = value != null ? string + "\nBase-Value:\t " + ((IRValue)value).getAbsoluteName() : string + "\nBase-Value:\t:none";
        Interface[] interfaceArray = this.getInterfaces();
        if (interfaceArray.length > 0) {
            string = string + "\nImplemented-Interfaces:\t ";
            for (int i = 0; i < interfaceArray.length; ++i) {
                string = string + ((TypeSystemNode)((Object)interfaceArray[i])).getAbsoluteName();
                if (i == interfaceArray.length - 1) continue;
                string = string + ", ";
            }
        } else {
            string = string + "\nImplemented-Interfaces:\t:none";
        }
        if ((valueArray = this.getAbstractBaseValues()).length > 0) {
            string = string + "\nAbstract-Base-Values:\t ";
            for (int i = 0; i < valueArray.length; ++i) {
                string = string + ((TypeSystemNode)((Object)valueArray[i])).getAbsoluteName();
                if (i == valueArray.length - 1) continue;
                string = string + ", ";
            }
        } else {
            string = string + "\nAbstract-Base-Values:\t:none";
        }
        return string;
    }

    @Override
    public TypeSystemNode[] getAllFields() {
        if (this.allFields == null) {
            int n;
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getInterfaces();
            for (int i = 0; i < interfaceArray.length; ++i) {
                TypeSystemNode[] typeSystemNodeArray = interfaceArray[i].getAllFields();
                for (int j = 0; j < typeSystemNodeArray.length; ++j) {
                    vector.addElement(typeSystemNodeArray[j]);
                }
            }
            Value[] valueArray = this.getAbstractBaseValues();
            for (int i = 0; i < valueArray.length; ++i) {
                TypeSystemNode[] typeSystemNodeArray = valueArray[i].getAllFields();
                for (int j = 0; j < typeSystemNodeArray.length; ++j) {
                    if (!(typeSystemNodeArray[j] instanceof IRAttribute)) continue;
                    vector.addElement(typeSystemNodeArray[j]);
                }
            }
            ModelParticipant[] modelParticipantArray = this.contents();
            for (n = 0; n < modelParticipantArray.length; ++n) {
                if (!(modelParticipantArray[n] instanceof IRAttribute)) continue;
                vector.addElement(modelParticipantArray[n]);
            }
            this.allFields = new IRAttribute[vector.size()];
            n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allFields[n] = (IRAttribute)enumeration.nextElement();
                ++n;
            }
        }
        return this.allFields;
    }

    @Override
    public TypeSystemNode[] getAllOperations() {
        if (this.allOperations == null) {
            int n;
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getInterfaces();
            for (int i = 0; i < interfaceArray.length; ++i) {
                TypeSystemNode[] typeSystemNodeArray = interfaceArray[i].getAllOperations();
                for (int j = 0; j < typeSystemNodeArray.length; ++j) {
                    vector.addElement(typeSystemNodeArray[j]);
                }
            }
            ModelParticipant[] modelParticipantArray = this.contents();
            for (n = 0; n < modelParticipantArray.length; ++n) {
                if (!(modelParticipantArray[n] instanceof IROperation)) continue;
                vector.addElement(modelParticipantArray[n]);
            }
            this.allOperations = new IROperation[vector.size()];
            n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allOperations[n] = (IROperation)enumeration.nextElement();
                ++n;
            }
        }
        return this.allOperations;
    }

    @Override
    public Value getBaseValue() {
        if (!this.lookedUpBaseValue) {
            ValueDef valueDef = ValueDefHelper.narrow(this.irObject);
            ValueDef valueDef2 = valueDef.base_value();
            if (valueDef2 != null) {
                this.baseValue = (Value)((Object)RemoteTypeSystem.createTypeSystemNode(valueDef2));
            }
            this.lookedUpBaseValue = true;
        }
        return this.baseValue;
    }

    public Value[] getAbstractBaseValues() {
        if (this.abstractBaseValues == null) {
            ValueDef valueDef = ValueDefHelper.narrow(this.irObject);
            ValueDef[] valueDefArray = valueDef.abstract_base_values();
            this.abstractBaseValues = new Value[valueDefArray.length];
            for (int i = 0; i < valueDefArray.length; ++i) {
                this.abstractBaseValues[i] = (Value)((Object)RemoteTypeSystem.createTypeSystemNode(valueDefArray[i]));
            }
        }
        return this.abstractBaseValues;
    }

    @Override
    public TypeSystemNode[] getAllMembers() {
        if (this.allMembers == null) {
            int n;
            int n2;
            Object[] objectArray;
            Vector<Object> vector = new Vector<Object>();
            Value value = this.getBaseValue();
            if (value != null) {
                objectArray = value.getAllMembers();
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    vector.addElement(objectArray[n2]);
                }
            }
            objectArray = this.getAbstractBaseValues();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                TypeSystemNode[] typeSystemNodeArray = objectArray[n2].getAllMembers();
                for (int i = 0; i < typeSystemNodeArray.length; ++i) {
                    vector.addElement(typeSystemNodeArray[i]);
                }
            }
            ModelParticipant[] modelParticipantArray = this.contents();
            for (n = 0; n < modelParticipantArray.length; ++n) {
                if (!(modelParticipantArray[n] instanceof IRValueMember)) continue;
                vector.addElement(modelParticipantArray[n]);
            }
            this.allMembers = new IRValueMember[vector.size()];
            n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allMembers[n] = (IRValueMember)enumeration.nextElement();
                ++n;
            }
        }
        return this.allMembers;
    }

    @Override
    public Interface[] getInterfaces() {
        if (this.interfaces == null) {
            ValueDef valueDef = ValueDefHelper.narrow(this.irObject);
            InterfaceDef[] interfaceDefArray = valueDef.supported_interfaces();
            this.interfaces = new IRInterface[interfaceDefArray.length];
            for (int i = 0; i < interfaceDefArray.length; ++i) {
                IRInterface iRInterface;
                this.interfaces[i] = iRInterface = (IRInterface)RemoteTypeSystem.createTypeSystemNode(interfaceDefArray[i]);
            }
        }
        return this.interfaces;
    }

    public static String nodeTypeName() {
        return "value";
    }

    @Override
    protected void setIRObject(IRObject iRObject) {
        super.setIRObject(iRObject);
    }
}

